package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.{StreamArn, TableName}
import scala.jdk.CollectionConverters.*
final case class DisableKinesisStreamingDestinationRequest(
    tableName: TableName,
    streamArn: StreamArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DisableKinesisStreamingDestinationRequest = {
    import DisableKinesisStreamingDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DisableKinesisStreamingDestinationRequest
      .builder()
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .streamArn(StreamArn.unwrap(streamArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.DisableKinesisStreamingDestinationRequest.ReadOnly =
    zio.aws.dynamodb.model.DisableKinesisStreamingDestinationRequest
      .wrap(buildAwsValue())
}
object DisableKinesisStreamingDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DisableKinesisStreamingDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dynamodb.model.DisableKinesisStreamingDestinationRequest =
      zio.aws.dynamodb.model
        .DisableKinesisStreamingDestinationRequest(tableName, streamArn)
    def tableName: TableName
    def streamArn: StreamArn
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getStreamArn: ZIO[Any, Nothing, StreamArn] = ZIO.succeed(streamArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DisableKinesisStreamingDestinationRequest
  ) extends zio.aws.dynamodb.model.DisableKinesisStreamingDestinationRequest.ReadOnly {
    override val tableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.tableName())
    override val streamArn: StreamArn =
      zio.aws.dynamodb.model.primitives.StreamArn(impl.streamArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DisableKinesisStreamingDestinationRequest
  ): zio.aws.dynamodb.model.DisableKinesisStreamingDestinationRequest.ReadOnly =
    new Wrapper(impl)
}
