package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.TableName
import scala.jdk.CollectionConverters.*
final case class CreateTableRequest(
    attributeDefinitions: Iterable[zio.aws.dynamodb.model.AttributeDefinition],
    tableName: TableName,
    keySchema: Iterable[zio.aws.dynamodb.model.KeySchemaElement],
    localSecondaryIndexes: Option[
      Iterable[zio.aws.dynamodb.model.LocalSecondaryIndex]
    ] = None,
    globalSecondaryIndexes: Option[
      Iterable[zio.aws.dynamodb.model.GlobalSecondaryIndex]
    ] = None,
    billingMode: Option[zio.aws.dynamodb.model.BillingMode] = None,
    provisionedThroughput: Option[
      zio.aws.dynamodb.model.ProvisionedThroughput
    ] = None,
    streamSpecification: Option[zio.aws.dynamodb.model.StreamSpecification] =
      None,
    sseSpecification: Option[zio.aws.dynamodb.model.SSESpecification] = None,
    tags: Option[Iterable[zio.aws.dynamodb.model.Tag]] = None,
    tableClass: Option[zio.aws.dynamodb.model.TableClass] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.CreateTableRequest = {
    import CreateTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.CreateTableRequest
      .builder()
      .attributeDefinitions(attributeDefinitions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .keySchema(keySchema.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        localSecondaryIndexes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.localSecondaryIndexes)
      .optionallyWith(
        globalSecondaryIndexes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalSecondaryIndexes)
      .optionallyWith(billingMode.map(value => value.unwrap))(_.billingMode)
      .optionallyWith(
        provisionedThroughput.map(value => value.buildAwsValue())
      )(_.provisionedThroughput)
      .optionallyWith(streamSpecification.map(value => value.buildAwsValue()))(
        _.streamSpecification
      )
      .optionallyWith(sseSpecification.map(value => value.buildAwsValue()))(
        _.sseSpecification
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(tableClass.map(value => value.unwrap))(_.tableClass)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.CreateTableRequest.ReadOnly =
    zio.aws.dynamodb.model.CreateTableRequest.wrap(buildAwsValue())
}
object CreateTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.CreateTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.CreateTableRequest =
      zio.aws.dynamodb.model.CreateTableRequest(
        attributeDefinitions.map { item =>
          item.asEditable
        },
        tableName,
        keySchema.map { item =>
          item.asEditable
        },
        localSecondaryIndexes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        globalSecondaryIndexes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        billingMode.map(value => value),
        provisionedThroughput.map(value => value.asEditable),
        streamSpecification.map(value => value.asEditable),
        sseSpecification.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tableClass.map(value => value)
      )
    def attributeDefinitions
        : List[zio.aws.dynamodb.model.AttributeDefinition.ReadOnly]
    def tableName: TableName
    def keySchema: List[zio.aws.dynamodb.model.KeySchemaElement.ReadOnly]
    def localSecondaryIndexes
        : Option[List[zio.aws.dynamodb.model.LocalSecondaryIndex.ReadOnly]]
    def globalSecondaryIndexes
        : Option[List[zio.aws.dynamodb.model.GlobalSecondaryIndex.ReadOnly]]
    def billingMode: Option[zio.aws.dynamodb.model.BillingMode]
    def provisionedThroughput
        : Option[zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly]
    def streamSpecification
        : Option[zio.aws.dynamodb.model.StreamSpecification.ReadOnly]
    def sseSpecification
        : Option[zio.aws.dynamodb.model.SSESpecification.ReadOnly]
    def tags: Option[List[zio.aws.dynamodb.model.Tag.ReadOnly]]
    def tableClass: Option[zio.aws.dynamodb.model.TableClass]
    def getAttributeDefinitions: ZIO[Any, Nothing, List[
      zio.aws.dynamodb.model.AttributeDefinition.ReadOnly
    ]] = ZIO.succeed(attributeDefinitions)
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getKeySchema: ZIO[Any, Nothing, List[
      zio.aws.dynamodb.model.KeySchemaElement.ReadOnly
    ]] = ZIO.succeed(keySchema)
    def getLocalSecondaryIndexes: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.LocalSecondaryIndex.ReadOnly
    ]] =
      AwsError.unwrapOptionField("localSecondaryIndexes", localSecondaryIndexes)
    def getGlobalSecondaryIndexes: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.GlobalSecondaryIndex.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "globalSecondaryIndexes",
      globalSecondaryIndexes
    )
    def getBillingMode: ZIO[Any, AwsError, zio.aws.dynamodb.model.BillingMode] =
      AwsError.unwrapOptionField("billingMode", billingMode)
    def getProvisionedThroughput: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly
    ] =
      AwsError.unwrapOptionField("provisionedThroughput", provisionedThroughput)
    def getStreamSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.StreamSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("streamSpecification", streamSpecification)
    def getSseSpecification
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.SSESpecification.ReadOnly] =
      AwsError.unwrapOptionField("sseSpecification", sseSpecification)
    def getTags: ZIO[Any, AwsError, List[zio.aws.dynamodb.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTableClass: ZIO[Any, AwsError, zio.aws.dynamodb.model.TableClass] =
      AwsError.unwrapOptionField("tableClass", tableClass)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.CreateTableRequest
  ) extends zio.aws.dynamodb.model.CreateTableRequest.ReadOnly {
    override val attributeDefinitions
        : List[zio.aws.dynamodb.model.AttributeDefinition.ReadOnly] = impl
      .attributeDefinitions()
      .asScala
      .map { item =>
        zio.aws.dynamodb.model.AttributeDefinition.wrap(item)
      }
      .toList
    override val tableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.tableName())
    override val keySchema
        : List[zio.aws.dynamodb.model.KeySchemaElement.ReadOnly] = impl
      .keySchema()
      .asScala
      .map { item =>
        zio.aws.dynamodb.model.KeySchemaElement.wrap(item)
      }
      .toList
    override val localSecondaryIndexes
        : Option[List[zio.aws.dynamodb.model.LocalSecondaryIndex.ReadOnly]] =
      scala
        .Option(impl.localSecondaryIndexes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.LocalSecondaryIndex.wrap(item)
          }.toList
        )
    override val globalSecondaryIndexes
        : Option[List[zio.aws.dynamodb.model.GlobalSecondaryIndex.ReadOnly]] =
      scala
        .Option(impl.globalSecondaryIndexes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.GlobalSecondaryIndex.wrap(item)
          }.toList
        )
    override val billingMode: Option[zio.aws.dynamodb.model.BillingMode] = scala
      .Option(impl.billingMode())
      .map(value => zio.aws.dynamodb.model.BillingMode.wrap(value))
    override val provisionedThroughput
        : Option[zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly] = scala
      .Option(impl.provisionedThroughput())
      .map(value => zio.aws.dynamodb.model.ProvisionedThroughput.wrap(value))
    override val streamSpecification
        : Option[zio.aws.dynamodb.model.StreamSpecification.ReadOnly] = scala
      .Option(impl.streamSpecification())
      .map(value => zio.aws.dynamodb.model.StreamSpecification.wrap(value))
    override val sseSpecification
        : Option[zio.aws.dynamodb.model.SSESpecification.ReadOnly] = scala
      .Option(impl.sseSpecification())
      .map(value => zio.aws.dynamodb.model.SSESpecification.wrap(value))
    override val tags: Option[List[zio.aws.dynamodb.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.Tag.wrap(item)
        }.toList
      )
    override val tableClass: Option[zio.aws.dynamodb.model.TableClass] = scala
      .Option(impl.tableClass())
      .map(value => zio.aws.dynamodb.model.TableClass.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.CreateTableRequest
  ): zio.aws.dynamodb.model.CreateTableRequest.ReadOnly = new Wrapper(impl)
}
