package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BatchStatementError(
    code: Option[zio.aws.dynamodb.model.BatchStatementErrorCodeEnum] = None,
    message: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.BatchStatementError = {
    import BatchStatementError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.BatchStatementError
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.BatchStatementError.ReadOnly =
    zio.aws.dynamodb.model.BatchStatementError.wrap(buildAwsValue())
}
object BatchStatementError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.BatchStatementError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.BatchStatementError =
      zio.aws.dynamodb.model.BatchStatementError(
        code.map(value => value),
        message.map(value => value)
      )
    def code: Option[zio.aws.dynamodb.model.BatchStatementErrorCodeEnum]
    def message: Option[String]
    def getCode: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.BatchStatementErrorCodeEnum
    ] = AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.BatchStatementError
  ) extends zio.aws.dynamodb.model.BatchStatementError.ReadOnly {
    override val code
        : Option[zio.aws.dynamodb.model.BatchStatementErrorCodeEnum] = scala
      .Option(impl.code())
      .map(value =>
        zio.aws.dynamodb.model.BatchStatementErrorCodeEnum.wrap(value)
      )
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.BatchStatementError
  ): zio.aws.dynamodb.model.BatchStatementError.ReadOnly = new Wrapper(impl)
}
