package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{BooleanObject, PositiveLongObject}
import scala.jdk.CollectionConverters.*
final case class AutoScalingSettingsDescription(
    minimumUnits: Option[PositiveLongObject] = None,
    maximumUnits: Option[PositiveLongObject] = None,
    autoScalingDisabled: Option[BooleanObject] = None,
    autoScalingRoleArn: Option[String] = None,
    scalingPolicies: Option[
      Iterable[zio.aws.dynamodb.model.AutoScalingPolicyDescription]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsDescription = {
    import AutoScalingSettingsDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsDescription
      .builder()
      .optionallyWith(
        minimumUnits.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.minimumUnits)
      .optionallyWith(
        maximumUnits.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.maximumUnits)
      .optionallyWith(
        autoScalingDisabled.map(value => value: java.lang.Boolean)
      )(_.autoScalingDisabled)
      .optionallyWith(autoScalingRoleArn.map(value => value: java.lang.String))(
        _.autoScalingRoleArn
      )
      .optionallyWith(
        scalingPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scalingPolicies)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly =
    zio.aws.dynamodb.model.AutoScalingSettingsDescription.wrap(buildAwsValue())
}
object AutoScalingSettingsDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.AutoScalingSettingsDescription =
      zio.aws.dynamodb.model.AutoScalingSettingsDescription(
        minimumUnits.map(value => value),
        maximumUnits.map(value => value),
        autoScalingDisabled.map(value => value),
        autoScalingRoleArn.map(value => value),
        scalingPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def minimumUnits: Option[PositiveLongObject]
    def maximumUnits: Option[PositiveLongObject]
    def autoScalingDisabled: Option[BooleanObject]
    def autoScalingRoleArn: Option[String]
    def scalingPolicies: Option[
      List[zio.aws.dynamodb.model.AutoScalingPolicyDescription.ReadOnly]
    ]
    def getMinimumUnits: ZIO[Any, AwsError, PositiveLongObject] =
      AwsError.unwrapOptionField("minimumUnits", minimumUnits)
    def getMaximumUnits: ZIO[Any, AwsError, PositiveLongObject] =
      AwsError.unwrapOptionField("maximumUnits", maximumUnits)
    def getAutoScalingDisabled: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("autoScalingDisabled", autoScalingDisabled)
    def getAutoScalingRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("autoScalingRoleArn", autoScalingRoleArn)
    def getScalingPolicies: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.AutoScalingPolicyDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("scalingPolicies", scalingPolicies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsDescription
  ) extends zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly {
    override val minimumUnits: Option[PositiveLongObject] = scala
      .Option(impl.minimumUnits())
      .map(value => zio.aws.dynamodb.model.primitives.PositiveLongObject(value))
    override val maximumUnits: Option[PositiveLongObject] = scala
      .Option(impl.maximumUnits())
      .map(value => zio.aws.dynamodb.model.primitives.PositiveLongObject(value))
    override val autoScalingDisabled: Option[BooleanObject] = scala
      .Option(impl.autoScalingDisabled())
      .map(value => value: BooleanObject)
    override val autoScalingRoleArn: Option[String] =
      scala.Option(impl.autoScalingRoleArn()).map(value => value: String)
    override val scalingPolicies: Option[
      List[zio.aws.dynamodb.model.AutoScalingPolicyDescription.ReadOnly]
    ] = scala
      .Option(impl.scalingPolicies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.AutoScalingPolicyDescription.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsDescription
  ): zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly =
    new Wrapper(impl)
}
