package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{StreamArn, TableId, Date, TableName}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class TableDescription(
    attributeDefinitions: Option[
      Iterable[zio.aws.dynamodb.model.AttributeDefinition]
    ] = None,
    tableName: Option[TableName] = None,
    keySchema: Option[Iterable[zio.aws.dynamodb.model.KeySchemaElement]] = None,
    tableStatus: Option[zio.aws.dynamodb.model.TableStatus] = None,
    creationDateTime: Option[Date] = None,
    provisionedThroughput: Option[
      zio.aws.dynamodb.model.ProvisionedThroughputDescription
    ] = None,
    tableSizeBytes: Option[Long] = None,
    itemCount: Option[Long] = None,
    tableArn: Option[String] = None,
    tableId: Option[TableId] = None,
    billingModeSummary: Option[zio.aws.dynamodb.model.BillingModeSummary] =
      None,
    localSecondaryIndexes: Option[
      Iterable[zio.aws.dynamodb.model.LocalSecondaryIndexDescription]
    ] = None,
    globalSecondaryIndexes: Option[
      Iterable[zio.aws.dynamodb.model.GlobalSecondaryIndexDescription]
    ] = None,
    streamSpecification: Option[zio.aws.dynamodb.model.StreamSpecification] =
      None,
    latestStreamLabel: Option[String] = None,
    latestStreamArn: Option[StreamArn] = None,
    globalTableVersion: Option[String] = None,
    replicas: Option[Iterable[zio.aws.dynamodb.model.ReplicaDescription]] =
      None,
    restoreSummary: Option[zio.aws.dynamodb.model.RestoreSummary] = None,
    sseDescription: Option[zio.aws.dynamodb.model.SSEDescription] = None,
    archivalSummary: Option[zio.aws.dynamodb.model.ArchivalSummary] = None,
    tableClassSummary: Option[zio.aws.dynamodb.model.TableClassSummary] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.TableDescription = {
    import TableDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.TableDescription
      .builder()
      .optionallyWith(
        attributeDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributeDefinitions)
      .optionallyWith(
        tableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(
        keySchema.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keySchema)
      .optionallyWith(tableStatus.map(value => value.unwrap))(_.tableStatus)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        provisionedThroughput.map(value => value.buildAwsValue())
      )(_.provisionedThroughput)
      .optionallyWith(tableSizeBytes.map(value => value: java.lang.Long))(
        _.tableSizeBytes
      )
      .optionallyWith(itemCount.map(value => value: java.lang.Long))(
        _.itemCount
      )
      .optionallyWith(tableArn.map(value => value: java.lang.String))(
        _.tableArn
      )
      .optionallyWith(
        tableId.map(value => TableId.unwrap(value): java.lang.String)
      )(_.tableId)
      .optionallyWith(billingModeSummary.map(value => value.buildAwsValue()))(
        _.billingModeSummary
      )
      .optionallyWith(
        localSecondaryIndexes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.localSecondaryIndexes)
      .optionallyWith(
        globalSecondaryIndexes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalSecondaryIndexes)
      .optionallyWith(streamSpecification.map(value => value.buildAwsValue()))(
        _.streamSpecification
      )
      .optionallyWith(latestStreamLabel.map(value => value: java.lang.String))(
        _.latestStreamLabel
      )
      .optionallyWith(
        latestStreamArn.map(value => StreamArn.unwrap(value): java.lang.String)
      )(_.latestStreamArn)
      .optionallyWith(globalTableVersion.map(value => value: java.lang.String))(
        _.globalTableVersion
      )
      .optionallyWith(
        replicas.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicas)
      .optionallyWith(restoreSummary.map(value => value.buildAwsValue()))(
        _.restoreSummary
      )
      .optionallyWith(sseDescription.map(value => value.buildAwsValue()))(
        _.sseDescription
      )
      .optionallyWith(archivalSummary.map(value => value.buildAwsValue()))(
        _.archivalSummary
      )
      .optionallyWith(tableClassSummary.map(value => value.buildAwsValue()))(
        _.tableClassSummary
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.TableDescription.ReadOnly =
    zio.aws.dynamodb.model.TableDescription.wrap(buildAwsValue())
}
object TableDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.TableDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.TableDescription =
      zio.aws.dynamodb.model.TableDescription(
        attributeDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tableName.map(value => value),
        keySchema.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tableStatus.map(value => value),
        creationDateTime.map(value => value),
        provisionedThroughput.map(value => value.asEditable),
        tableSizeBytes.map(value => value),
        itemCount.map(value => value),
        tableArn.map(value => value),
        tableId.map(value => value),
        billingModeSummary.map(value => value.asEditable),
        localSecondaryIndexes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        globalSecondaryIndexes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        streamSpecification.map(value => value.asEditable),
        latestStreamLabel.map(value => value),
        latestStreamArn.map(value => value),
        globalTableVersion.map(value => value),
        replicas.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        restoreSummary.map(value => value.asEditable),
        sseDescription.map(value => value.asEditable),
        archivalSummary.map(value => value.asEditable),
        tableClassSummary.map(value => value.asEditable)
      )
    def attributeDefinitions
        : Option[List[zio.aws.dynamodb.model.AttributeDefinition.ReadOnly]]
    def tableName: Option[TableName]
    def keySchema
        : Option[List[zio.aws.dynamodb.model.KeySchemaElement.ReadOnly]]
    def tableStatus: Option[zio.aws.dynamodb.model.TableStatus]
    def creationDateTime: Option[Date]
    def provisionedThroughput: Option[
      zio.aws.dynamodb.model.ProvisionedThroughputDescription.ReadOnly
    ]
    def tableSizeBytes: Option[Long]
    def itemCount: Option[Long]
    def tableArn: Option[String]
    def tableId: Option[TableId]
    def billingModeSummary
        : Option[zio.aws.dynamodb.model.BillingModeSummary.ReadOnly]
    def localSecondaryIndexes: Option[
      List[zio.aws.dynamodb.model.LocalSecondaryIndexDescription.ReadOnly]
    ]
    def globalSecondaryIndexes: Option[
      List[zio.aws.dynamodb.model.GlobalSecondaryIndexDescription.ReadOnly]
    ]
    def streamSpecification
        : Option[zio.aws.dynamodb.model.StreamSpecification.ReadOnly]
    def latestStreamLabel: Option[String]
    def latestStreamArn: Option[StreamArn]
    def globalTableVersion: Option[String]
    def replicas
        : Option[List[zio.aws.dynamodb.model.ReplicaDescription.ReadOnly]]
    def restoreSummary: Option[zio.aws.dynamodb.model.RestoreSummary.ReadOnly]
    def sseDescription: Option[zio.aws.dynamodb.model.SSEDescription.ReadOnly]
    def archivalSummary: Option[zio.aws.dynamodb.model.ArchivalSummary.ReadOnly]
    def tableClassSummary
        : Option[zio.aws.dynamodb.model.TableClassSummary.ReadOnly]
    def getAttributeDefinitions: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.AttributeDefinition.ReadOnly
    ]] =
      AwsError.unwrapOptionField("attributeDefinitions", attributeDefinitions)
    def getTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getKeySchema: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.KeySchemaElement.ReadOnly
    ]] = AwsError.unwrapOptionField("keySchema", keySchema)
    def getTableStatus: ZIO[Any, AwsError, zio.aws.dynamodb.model.TableStatus] =
      AwsError.unwrapOptionField("tableStatus", tableStatus)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getProvisionedThroughput: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ProvisionedThroughputDescription.ReadOnly
    ] =
      AwsError.unwrapOptionField("provisionedThroughput", provisionedThroughput)
    def getTableSizeBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("tableSizeBytes", tableSizeBytes)
    def getItemCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("itemCount", itemCount)
    def getTableArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tableArn", tableArn)
    def getTableId: ZIO[Any, AwsError, TableId] =
      AwsError.unwrapOptionField("tableId", tableId)
    def getBillingModeSummary: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.BillingModeSummary.ReadOnly
    ] = AwsError.unwrapOptionField("billingModeSummary", billingModeSummary)
    def getLocalSecondaryIndexes: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.LocalSecondaryIndexDescription.ReadOnly
    ]] =
      AwsError.unwrapOptionField("localSecondaryIndexes", localSecondaryIndexes)
    def getGlobalSecondaryIndexes: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.GlobalSecondaryIndexDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "globalSecondaryIndexes",
      globalSecondaryIndexes
    )
    def getStreamSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.StreamSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("streamSpecification", streamSpecification)
    def getLatestStreamLabel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("latestStreamLabel", latestStreamLabel)
    def getLatestStreamArn: ZIO[Any, AwsError, StreamArn] =
      AwsError.unwrapOptionField("latestStreamArn", latestStreamArn)
    def getGlobalTableVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("globalTableVersion", globalTableVersion)
    def getReplicas: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ReplicaDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("replicas", replicas)
    def getRestoreSummary
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.RestoreSummary.ReadOnly] =
      AwsError.unwrapOptionField("restoreSummary", restoreSummary)
    def getSseDescription
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.SSEDescription.ReadOnly] =
      AwsError.unwrapOptionField("sseDescription", sseDescription)
    def getArchivalSummary
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ArchivalSummary.ReadOnly] =
      AwsError.unwrapOptionField("archivalSummary", archivalSummary)
    def getTableClassSummary: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.TableClassSummary.ReadOnly
    ] = AwsError.unwrapOptionField("tableClassSummary", tableClassSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.TableDescription
  ) extends zio.aws.dynamodb.model.TableDescription.ReadOnly {
    override val attributeDefinitions
        : Option[List[zio.aws.dynamodb.model.AttributeDefinition.ReadOnly]] =
      scala
        .Option(impl.attributeDefinitions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.AttributeDefinition.wrap(item)
          }.toList
        )
    override val tableName: Option[TableName] = scala
      .Option(impl.tableName())
      .map(value => zio.aws.dynamodb.model.primitives.TableName(value))
    override val keySchema
        : Option[List[zio.aws.dynamodb.model.KeySchemaElement.ReadOnly]] = scala
      .Option(impl.keySchema())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.KeySchemaElement.wrap(item)
        }.toList
      )
    override val tableStatus: Option[zio.aws.dynamodb.model.TableStatus] = scala
      .Option(impl.tableStatus())
      .map(value => zio.aws.dynamodb.model.TableStatus.wrap(value))
    override val creationDateTime: Option[Date] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.dynamodb.model.primitives.Date(value))
    override val provisionedThroughput: Option[
      zio.aws.dynamodb.model.ProvisionedThroughputDescription.ReadOnly
    ] = scala
      .Option(impl.provisionedThroughput())
      .map(value =>
        zio.aws.dynamodb.model.ProvisionedThroughputDescription.wrap(value)
      )
    override val tableSizeBytes: Option[Long] =
      scala.Option(impl.tableSizeBytes()).map(value => value: Long)
    override val itemCount: Option[Long] =
      scala.Option(impl.itemCount()).map(value => value: Long)
    override val tableArn: Option[String] =
      scala.Option(impl.tableArn()).map(value => value: String)
    override val tableId: Option[TableId] = scala
      .Option(impl.tableId())
      .map(value => zio.aws.dynamodb.model.primitives.TableId(value))
    override val billingModeSummary
        : Option[zio.aws.dynamodb.model.BillingModeSummary.ReadOnly] = scala
      .Option(impl.billingModeSummary())
      .map(value => zio.aws.dynamodb.model.BillingModeSummary.wrap(value))
    override val localSecondaryIndexes: Option[
      List[zio.aws.dynamodb.model.LocalSecondaryIndexDescription.ReadOnly]
    ] = scala
      .Option(impl.localSecondaryIndexes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.LocalSecondaryIndexDescription.wrap(item)
        }.toList
      )
    override val globalSecondaryIndexes: Option[
      List[zio.aws.dynamodb.model.GlobalSecondaryIndexDescription.ReadOnly]
    ] = scala
      .Option(impl.globalSecondaryIndexes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.GlobalSecondaryIndexDescription.wrap(item)
        }.toList
      )
    override val streamSpecification
        : Option[zio.aws.dynamodb.model.StreamSpecification.ReadOnly] = scala
      .Option(impl.streamSpecification())
      .map(value => zio.aws.dynamodb.model.StreamSpecification.wrap(value))
    override val latestStreamLabel: Option[String] =
      scala.Option(impl.latestStreamLabel()).map(value => value: String)
    override val latestStreamArn: Option[StreamArn] = scala
      .Option(impl.latestStreamArn())
      .map(value => zio.aws.dynamodb.model.primitives.StreamArn(value))
    override val globalTableVersion: Option[String] =
      scala.Option(impl.globalTableVersion()).map(value => value: String)
    override val replicas
        : Option[List[zio.aws.dynamodb.model.ReplicaDescription.ReadOnly]] =
      scala
        .Option(impl.replicas())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.ReplicaDescription.wrap(item)
          }.toList
        )
    override val restoreSummary
        : Option[zio.aws.dynamodb.model.RestoreSummary.ReadOnly] = scala
      .Option(impl.restoreSummary())
      .map(value => zio.aws.dynamodb.model.RestoreSummary.wrap(value))
    override val sseDescription
        : Option[zio.aws.dynamodb.model.SSEDescription.ReadOnly] = scala
      .Option(impl.sseDescription())
      .map(value => zio.aws.dynamodb.model.SSEDescription.wrap(value))
    override val archivalSummary
        : Option[zio.aws.dynamodb.model.ArchivalSummary.ReadOnly] = scala
      .Option(impl.archivalSummary())
      .map(value => zio.aws.dynamodb.model.ArchivalSummary.wrap(value))
    override val tableClassSummary
        : Option[zio.aws.dynamodb.model.TableClassSummary.ReadOnly] = scala
      .Option(impl.tableClassSummary())
      .map(value => zio.aws.dynamodb.model.TableClassSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.TableDescription
  ): zio.aws.dynamodb.model.TableDescription.ReadOnly = new Wrapper(impl)
}
