package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{PartiQLNextToken, AttributeName}
import scala.jdk.CollectionConverters.*
final case class ExecuteStatementResponse(
    items: Option[
      Iterable[Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]]
    ] = None,
    nextToken: Option[PartiQLNextToken] = None,
    consumedCapacity: Option[zio.aws.dynamodb.model.ConsumedCapacity] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ExecuteStatementResponse = {
    import ExecuteStatementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ExecuteStatementResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item
              .map({ case (key, value) =>
                (AttributeName.unwrap(key): java.lang.String) -> value
                  .buildAwsValue()
              })
              .asJava
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => PartiQLNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(consumedCapacity.map(value => value.buildAwsValue()))(
        _.consumedCapacity
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ExecuteStatementResponse.ReadOnly =
    zio.aws.dynamodb.model.ExecuteStatementResponse.wrap(buildAwsValue())
}
object ExecuteStatementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ExecuteStatementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ExecuteStatementResponse =
      zio.aws.dynamodb.model.ExecuteStatementResponse(
        items.map(value =>
          value.map { item =>
            item.map({ case (key, value) =>
              key -> value.asEditable
            })
          }
        ),
        nextToken.map(value => value),
        consumedCapacity.map(value => value.asEditable)
      )
    def items: Option[
      List[Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]]
    ]
    def nextToken: Option[PartiQLNextToken]
    def consumedCapacity
        : Option[zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly]
    def getItems: ZIO[Any, AwsError, List[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, PartiQLNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getConsumedCapacity
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly] =
      AwsError.unwrapOptionField("consumedCapacity", consumedCapacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ExecuteStatementResponse
  ) extends zio.aws.dynamodb.model.ExecuteStatementResponse.ReadOnly {
    override val items: Option[
      List[Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]]
    ] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala.map { item =>
          item.asScala
            .map({ case (key, value) =>
              zio.aws.dynamodb.model.primitives.AttributeName(
                key
              ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
            })
            .toMap
        }.toList
      )
    override val nextToken: Option[PartiQLNextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.dynamodb.model.primitives.PartiQLNextToken(value))
    override val consumedCapacity
        : Option[zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly] = scala
      .Option(impl.consumedCapacity())
      .map(value => zio.aws.dynamodb.model.ConsumedCapacity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ExecuteStatementResponse
  ): zio.aws.dynamodb.model.ExecuteStatementResponse.ReadOnly = new Wrapper(
    impl
  )
}
