package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateTableResponse(
    tableDescription: Option[zio.aws.dynamodb.model.TableDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.CreateTableResponse = {
    import CreateTableResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.CreateTableResponse
      .builder()
      .optionallyWith(tableDescription.map(value => value.buildAwsValue()))(
        _.tableDescription
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.CreateTableResponse.ReadOnly =
    zio.aws.dynamodb.model.CreateTableResponse.wrap(buildAwsValue())
}
object CreateTableResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.CreateTableResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.CreateTableResponse =
      zio.aws.dynamodb.model
        .CreateTableResponse(tableDescription.map(value => value.asEditable))
    def tableDescription
        : Option[zio.aws.dynamodb.model.TableDescription.ReadOnly]
    def getTableDescription
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.TableDescription.ReadOnly] =
      AwsError.unwrapOptionField("tableDescription", tableDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.CreateTableResponse
  ) extends zio.aws.dynamodb.model.CreateTableResponse.ReadOnly {
    override val tableDescription
        : Option[zio.aws.dynamodb.model.TableDescription.ReadOnly] = scala
      .Option(impl.tableDescription())
      .map(value => zio.aws.dynamodb.model.TableDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.CreateTableResponse
  ): zio.aws.dynamodb.model.CreateTableResponse.ReadOnly = new Wrapper(impl)
}
