package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.ConsumedCapacityUnits
import scala.jdk.CollectionConverters.*
final case class Capacity(
    readCapacityUnits: Option[ConsumedCapacityUnits] = None,
    writeCapacityUnits: Option[ConsumedCapacityUnits] = None,
    capacityUnits: Option[ConsumedCapacityUnits] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.Capacity = {
    import Capacity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.Capacity
      .builder()
      .optionallyWith(
        readCapacityUnits.map(value =>
          ConsumedCapacityUnits.unwrap(value): java.lang.Double
        )
      )(_.readCapacityUnits)
      .optionallyWith(
        writeCapacityUnits.map(value =>
          ConsumedCapacityUnits.unwrap(value): java.lang.Double
        )
      )(_.writeCapacityUnits)
      .optionallyWith(
        capacityUnits.map(value =>
          ConsumedCapacityUnits.unwrap(value): java.lang.Double
        )
      )(_.capacityUnits)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.Capacity.ReadOnly =
    zio.aws.dynamodb.model.Capacity.wrap(buildAwsValue())
}
object Capacity {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.dynamodb.model.Capacity] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.Capacity =
      zio.aws.dynamodb.model.Capacity(
        readCapacityUnits.map(value => value),
        writeCapacityUnits.map(value => value),
        capacityUnits.map(value => value)
      )
    def readCapacityUnits: Option[ConsumedCapacityUnits]
    def writeCapacityUnits: Option[ConsumedCapacityUnits]
    def capacityUnits: Option[ConsumedCapacityUnits]
    def getReadCapacityUnits: ZIO[Any, AwsError, ConsumedCapacityUnits] =
      AwsError.unwrapOptionField("readCapacityUnits", readCapacityUnits)
    def getWriteCapacityUnits: ZIO[Any, AwsError, ConsumedCapacityUnits] =
      AwsError.unwrapOptionField("writeCapacityUnits", writeCapacityUnits)
    def getCapacityUnits: ZIO[Any, AwsError, ConsumedCapacityUnits] =
      AwsError.unwrapOptionField("capacityUnits", capacityUnits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.Capacity
  ) extends zio.aws.dynamodb.model.Capacity.ReadOnly {
    override val readCapacityUnits: Option[ConsumedCapacityUnits] = scala
      .Option(impl.readCapacityUnits())
      .map(value =>
        zio.aws.dynamodb.model.primitives.ConsumedCapacityUnits(value)
      )
    override val writeCapacityUnits: Option[ConsumedCapacityUnits] = scala
      .Option(impl.writeCapacityUnits())
      .map(value =>
        zio.aws.dynamodb.model.primitives.ConsumedCapacityUnits(value)
      )
    override val capacityUnits: Option[ConsumedCapacityUnits] = scala
      .Option(impl.capacityUnits())
      .map(value =>
        zio.aws.dynamodb.model.primitives.ConsumedCapacityUnits(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.Capacity
  ): zio.aws.dynamodb.model.Capacity.ReadOnly = new Wrapper(impl)
}
