package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{
  BackupArn,
  BackupSizeBytes,
  Date,
  BackupCreationDateTime,
  BackupName
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class BackupDetails(
    backupArn: BackupArn,
    backupName: BackupName,
    backupSizeBytes: Option[BackupSizeBytes] = None,
    backupStatus: zio.aws.dynamodb.model.BackupStatus,
    backupType: zio.aws.dynamodb.model.BackupType,
    backupCreationDateTime: BackupCreationDateTime,
    backupExpiryDateTime: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.BackupDetails = {
    import BackupDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.BackupDetails
      .builder()
      .backupArn(BackupArn.unwrap(backupArn): java.lang.String)
      .backupName(BackupName.unwrap(backupName): java.lang.String)
      .optionallyWith(
        backupSizeBytes.map(value =>
          BackupSizeBytes.unwrap(value): java.lang.Long
        )
      )(_.backupSizeBytes)
      .backupStatus(backupStatus.unwrap)
      .backupType(backupType.unwrap)
      .backupCreationDateTime(
        BackupCreationDateTime.unwrap(backupCreationDateTime): Instant
      )
      .optionallyWith(
        backupExpiryDateTime.map(value => Date.unwrap(value): Instant)
      )(_.backupExpiryDateTime)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.BackupDetails.ReadOnly =
    zio.aws.dynamodb.model.BackupDetails.wrap(buildAwsValue())
}
object BackupDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.BackupDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.BackupDetails =
      zio.aws.dynamodb.model.BackupDetails(
        backupArn,
        backupName,
        backupSizeBytes.map(value => value),
        backupStatus,
        backupType,
        backupCreationDateTime,
        backupExpiryDateTime.map(value => value)
      )
    def backupArn: BackupArn
    def backupName: BackupName
    def backupSizeBytes: Option[BackupSizeBytes]
    def backupStatus: zio.aws.dynamodb.model.BackupStatus
    def backupType: zio.aws.dynamodb.model.BackupType
    def backupCreationDateTime: BackupCreationDateTime
    def backupExpiryDateTime: Option[Date]
    def getBackupArn: ZIO[Any, Nothing, BackupArn] = ZIO.succeed(backupArn)
    def getBackupName: ZIO[Any, Nothing, BackupName] = ZIO.succeed(backupName)
    def getBackupSizeBytes: ZIO[Any, AwsError, BackupSizeBytes] =
      AwsError.unwrapOptionField("backupSizeBytes", backupSizeBytes)
    def getBackupStatus
        : ZIO[Any, Nothing, zio.aws.dynamodb.model.BackupStatus] =
      ZIO.succeed(backupStatus)
    def getBackupType: ZIO[Any, Nothing, zio.aws.dynamodb.model.BackupType] =
      ZIO.succeed(backupType)
    def getBackupCreationDateTime: ZIO[Any, Nothing, BackupCreationDateTime] =
      ZIO.succeed(backupCreationDateTime)
    def getBackupExpiryDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("backupExpiryDateTime", backupExpiryDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.BackupDetails
  ) extends zio.aws.dynamodb.model.BackupDetails.ReadOnly {
    override val backupArn: BackupArn =
      zio.aws.dynamodb.model.primitives.BackupArn(impl.backupArn())
    override val backupName: BackupName =
      zio.aws.dynamodb.model.primitives.BackupName(impl.backupName())
    override val backupSizeBytes: Option[BackupSizeBytes] = scala
      .Option(impl.backupSizeBytes())
      .map(value => zio.aws.dynamodb.model.primitives.BackupSizeBytes(value))
    override val backupStatus: zio.aws.dynamodb.model.BackupStatus =
      zio.aws.dynamodb.model.BackupStatus.wrap(impl.backupStatus())
    override val backupType: zio.aws.dynamodb.model.BackupType =
      zio.aws.dynamodb.model.BackupType.wrap(impl.backupType())
    override val backupCreationDateTime: BackupCreationDateTime =
      zio.aws.dynamodb.model.primitives
        .BackupCreationDateTime(impl.backupCreationDateTime())
    override val backupExpiryDateTime: Option[Date] = scala
      .Option(impl.backupExpiryDateTime())
      .map(value => zio.aws.dynamodb.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.BackupDetails
  ): zio.aws.dynamodb.model.BackupDetails.ReadOnly = new Wrapper(impl)
}
