package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{BackupArn, ArchivalReason, Date}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ArchivalSummary(
    archivalDateTime: Option[Date] = None,
    archivalReason: Option[ArchivalReason] = None,
    archivalBackupArn: Option[BackupArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ArchivalSummary = {
    import ArchivalSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ArchivalSummary
      .builder()
      .optionallyWith(
        archivalDateTime.map(value => Date.unwrap(value): Instant)
      )(_.archivalDateTime)
      .optionallyWith(
        archivalReason.map(value =>
          ArchivalReason.unwrap(value): java.lang.String
        )
      )(_.archivalReason)
      .optionallyWith(
        archivalBackupArn.map(value =>
          BackupArn.unwrap(value): java.lang.String
        )
      )(_.archivalBackupArn)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ArchivalSummary.ReadOnly =
    zio.aws.dynamodb.model.ArchivalSummary.wrap(buildAwsValue())
}
object ArchivalSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ArchivalSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ArchivalSummary =
      zio.aws.dynamodb.model.ArchivalSummary(
        archivalDateTime.map(value => value),
        archivalReason.map(value => value),
        archivalBackupArn.map(value => value)
      )
    def archivalDateTime: Option[Date]
    def archivalReason: Option[ArchivalReason]
    def archivalBackupArn: Option[BackupArn]
    def getArchivalDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("archivalDateTime", archivalDateTime)
    def getArchivalReason: ZIO[Any, AwsError, ArchivalReason] =
      AwsError.unwrapOptionField("archivalReason", archivalReason)
    def getArchivalBackupArn: ZIO[Any, AwsError, BackupArn] =
      AwsError.unwrapOptionField("archivalBackupArn", archivalBackupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ArchivalSummary
  ) extends zio.aws.dynamodb.model.ArchivalSummary.ReadOnly {
    override val archivalDateTime: Option[Date] = scala
      .Option(impl.archivalDateTime())
      .map(value => zio.aws.dynamodb.model.primitives.Date(value))
    override val archivalReason: Option[ArchivalReason] = scala
      .Option(impl.archivalReason())
      .map(value => zio.aws.dynamodb.model.primitives.ArchivalReason(value))
    override val archivalBackupArn: Option[BackupArn] = scala
      .Option(impl.archivalBackupArn())
      .map(value => zio.aws.dynamodb.model.primitives.BackupArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ArchivalSummary
  ): zio.aws.dynamodb.model.ArchivalSummary.ReadOnly = new Wrapper(impl)
}
