package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{PositiveLongObject, IndexName}
import scala.jdk.CollectionConverters.*
final case class ReplicaGlobalSecondaryIndexSettingsDescription(
    indexName: IndexName,
    indexStatus: Option[zio.aws.dynamodb.model.IndexStatus] = None,
    provisionedReadCapacityUnits: Option[PositiveLongObject] = None,
    provisionedReadCapacityAutoScalingSettings: Option[
      zio.aws.dynamodb.model.AutoScalingSettingsDescription
    ] = None,
    provisionedWriteCapacityUnits: Option[PositiveLongObject] = None,
    provisionedWriteCapacityAutoScalingSettings: Option[
      zio.aws.dynamodb.model.AutoScalingSettingsDescription
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription = {
    import ReplicaGlobalSecondaryIndexSettingsDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription
      .builder()
      .indexName(IndexName.unwrap(indexName): java.lang.String)
      .optionallyWith(indexStatus.map(value => value.unwrap))(_.indexStatus)
      .optionallyWith(
        provisionedReadCapacityUnits.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.provisionedReadCapacityUnits)
      .optionallyWith(
        provisionedReadCapacityAutoScalingSettings.map(value =>
          value.buildAwsValue()
        )
      )(_.provisionedReadCapacityAutoScalingSettings)
      .optionallyWith(
        provisionedWriteCapacityUnits.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.provisionedWriteCapacityUnits)
      .optionallyWith(
        provisionedWriteCapacityAutoScalingSettings.map(value =>
          value.buildAwsValue()
        )
      )(_.provisionedWriteCapacityAutoScalingSettings)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription.ReadOnly =
    zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription
      .wrap(buildAwsValue())
}
object ReplicaGlobalSecondaryIndexSettingsDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription =
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription(
        indexName,
        indexStatus.map(value => value),
        provisionedReadCapacityUnits.map(value => value),
        provisionedReadCapacityAutoScalingSettings.map(value =>
          value.asEditable
        ),
        provisionedWriteCapacityUnits.map(value => value),
        provisionedWriteCapacityAutoScalingSettings.map(value =>
          value.asEditable
        )
      )
    def indexName: IndexName
    def indexStatus: Option[zio.aws.dynamodb.model.IndexStatus]
    def provisionedReadCapacityUnits: Option[PositiveLongObject]
    def provisionedReadCapacityAutoScalingSettings
        : Option[zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly]
    def provisionedWriteCapacityUnits: Option[PositiveLongObject]
    def provisionedWriteCapacityAutoScalingSettings
        : Option[zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly]
    def getIndexName: ZIO[Any, Nothing, IndexName] = ZIO.succeed(indexName)
    def getIndexStatus: ZIO[Any, AwsError, zio.aws.dynamodb.model.IndexStatus] =
      AwsError.unwrapOptionField("indexStatus", indexStatus)
    def getProvisionedReadCapacityUnits
        : ZIO[Any, AwsError, PositiveLongObject] = AwsError.unwrapOptionField(
      "provisionedReadCapacityUnits",
      provisionedReadCapacityUnits
    )
    def getProvisionedReadCapacityAutoScalingSettings: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisionedReadCapacityAutoScalingSettings",
      provisionedReadCapacityAutoScalingSettings
    )
    def getProvisionedWriteCapacityUnits
        : ZIO[Any, AwsError, PositiveLongObject] = AwsError.unwrapOptionField(
      "provisionedWriteCapacityUnits",
      provisionedWriteCapacityUnits
    )
    def getProvisionedWriteCapacityAutoScalingSettings: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisionedWriteCapacityAutoScalingSettings",
      provisionedWriteCapacityAutoScalingSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription
  ) extends zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription.ReadOnly {
    override val indexName: IndexName =
      zio.aws.dynamodb.model.primitives.IndexName(impl.indexName())
    override val indexStatus: Option[zio.aws.dynamodb.model.IndexStatus] = scala
      .Option(impl.indexStatus())
      .map(value => zio.aws.dynamodb.model.IndexStatus.wrap(value))
    override val provisionedReadCapacityUnits: Option[PositiveLongObject] =
      scala
        .Option(impl.provisionedReadCapacityUnits())
        .map(value =>
          zio.aws.dynamodb.model.primitives.PositiveLongObject(value)
        )
    override val provisionedReadCapacityAutoScalingSettings: Option[
      zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly
    ] = scala
      .Option(impl.provisionedReadCapacityAutoScalingSettings())
      .map(value =>
        zio.aws.dynamodb.model.AutoScalingSettingsDescription.wrap(value)
      )
    override val provisionedWriteCapacityUnits: Option[PositiveLongObject] =
      scala
        .Option(impl.provisionedWriteCapacityUnits())
        .map(value =>
          zio.aws.dynamodb.model.primitives.PositiveLongObject(value)
        )
    override val provisionedWriteCapacityAutoScalingSettings: Option[
      zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly
    ] = scala
      .Option(impl.provisionedWriteCapacityAutoScalingSettings())
      .map(value =>
        zio.aws.dynamodb.model.AutoScalingSettingsDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription
  ): zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription.ReadOnly =
    new Wrapper(impl)
}
