package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.IndexName
import scala.jdk.CollectionConverters.*
final case class ReplicaGlobalSecondaryIndex(
    indexName: IndexName,
    provisionedThroughputOverride: Option[
      zio.aws.dynamodb.model.ProvisionedThroughputOverride
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndex = {
    import ReplicaGlobalSecondaryIndex.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndex
      .builder()
      .indexName(IndexName.unwrap(indexName): java.lang.String)
      .optionallyWith(
        provisionedThroughputOverride.map(value => value.buildAwsValue())
      )(_.provisionedThroughputOverride)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndex.ReadOnly =
    zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndex.wrap(buildAwsValue())
}
object ReplicaGlobalSecondaryIndex {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndex
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndex =
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndex(
        indexName,
        provisionedThroughputOverride.map(value => value.asEditable)
      )
    def indexName: IndexName
    def provisionedThroughputOverride
        : Option[zio.aws.dynamodb.model.ProvisionedThroughputOverride.ReadOnly]
    def getIndexName: ZIO[Any, Nothing, IndexName] = ZIO.succeed(indexName)
    def getProvisionedThroughputOverride: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ProvisionedThroughputOverride.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisionedThroughputOverride",
      provisionedThroughputOverride
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndex
  ) extends zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndex.ReadOnly {
    override val indexName: IndexName =
      zio.aws.dynamodb.model.primitives.IndexName(impl.indexName())
    override val provisionedThroughputOverride: Option[
      zio.aws.dynamodb.model.ProvisionedThroughputOverride.ReadOnly
    ] = scala
      .Option(impl.provisionedThroughputOverride())
      .map(value =>
        zio.aws.dynamodb.model.ProvisionedThroughputOverride.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndex
  ): zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndex.ReadOnly = new Wrapper(
    impl
  )
}
