package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{
  NonNegativeLongObject,
  PositiveLongObject,
  Date
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ProvisionedThroughputDescription(
    lastIncreaseDateTime: Option[Date] = None,
    lastDecreaseDateTime: Option[Date] = None,
    numberOfDecreasesToday: Option[PositiveLongObject] = None,
    readCapacityUnits: Option[NonNegativeLongObject] = None,
    writeCapacityUnits: Option[NonNegativeLongObject] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputDescription = {
    import ProvisionedThroughputDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputDescription
      .builder()
      .optionallyWith(
        lastIncreaseDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastIncreaseDateTime)
      .optionallyWith(
        lastDecreaseDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastDecreaseDateTime)
      .optionallyWith(
        numberOfDecreasesToday.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.numberOfDecreasesToday)
      .optionallyWith(
        readCapacityUnits.map(value =>
          NonNegativeLongObject.unwrap(value): java.lang.Long
        )
      )(_.readCapacityUnits)
      .optionallyWith(
        writeCapacityUnits.map(value =>
          NonNegativeLongObject.unwrap(value): java.lang.Long
        )
      )(_.writeCapacityUnits)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.ProvisionedThroughputDescription.ReadOnly =
    zio.aws.dynamodb.model.ProvisionedThroughputDescription
      .wrap(buildAwsValue())
}
object ProvisionedThroughputDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ProvisionedThroughputDescription =
      zio.aws.dynamodb.model.ProvisionedThroughputDescription(
        lastIncreaseDateTime.map(value => value),
        lastDecreaseDateTime.map(value => value),
        numberOfDecreasesToday.map(value => value),
        readCapacityUnits.map(value => value),
        writeCapacityUnits.map(value => value)
      )
    def lastIncreaseDateTime: Option[Date]
    def lastDecreaseDateTime: Option[Date]
    def numberOfDecreasesToday: Option[PositiveLongObject]
    def readCapacityUnits: Option[NonNegativeLongObject]
    def writeCapacityUnits: Option[NonNegativeLongObject]
    def getLastIncreaseDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastIncreaseDateTime", lastIncreaseDateTime)
    def getLastDecreaseDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastDecreaseDateTime", lastDecreaseDateTime)
    def getNumberOfDecreasesToday: ZIO[Any, AwsError, PositiveLongObject] =
      AwsError.unwrapOptionField(
        "numberOfDecreasesToday",
        numberOfDecreasesToday
      )
    def getReadCapacityUnits: ZIO[Any, AwsError, NonNegativeLongObject] =
      AwsError.unwrapOptionField("readCapacityUnits", readCapacityUnits)
    def getWriteCapacityUnits: ZIO[Any, AwsError, NonNegativeLongObject] =
      AwsError.unwrapOptionField("writeCapacityUnits", writeCapacityUnits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputDescription
  ) extends zio.aws.dynamodb.model.ProvisionedThroughputDescription.ReadOnly {
    override val lastIncreaseDateTime: Option[Date] = scala
      .Option(impl.lastIncreaseDateTime())
      .map(value => zio.aws.dynamodb.model.primitives.Date(value))
    override val lastDecreaseDateTime: Option[Date] = scala
      .Option(impl.lastDecreaseDateTime())
      .map(value => zio.aws.dynamodb.model.primitives.Date(value))
    override val numberOfDecreasesToday: Option[PositiveLongObject] = scala
      .Option(impl.numberOfDecreasesToday())
      .map(value => zio.aws.dynamodb.model.primitives.PositiveLongObject(value))
    override val readCapacityUnits: Option[NonNegativeLongObject] = scala
      .Option(impl.readCapacityUnits())
      .map(value =>
        zio.aws.dynamodb.model.primitives.NonNegativeLongObject(value)
      )
    override val writeCapacityUnits: Option[NonNegativeLongObject] = scala
      .Option(impl.writeCapacityUnits())
      .map(value =>
        zio.aws.dynamodb.model.primitives.NonNegativeLongObject(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputDescription
  ): zio.aws.dynamodb.model.ProvisionedThroughputDescription.ReadOnly =
    new Wrapper(impl)
}
