package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.NextTokenString
import scala.jdk.CollectionConverters.*
final case class ListTagsOfResourceResponse(
    tags: Option[Iterable[zio.aws.dynamodb.model.Tag]] = None,
    nextToken: Option[NextTokenString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceResponse = {
    import ListTagsOfResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        nextToken.map(value => NextTokenString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ListTagsOfResourceResponse.ReadOnly =
    zio.aws.dynamodb.model.ListTagsOfResourceResponse.wrap(buildAwsValue())
}
object ListTagsOfResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ListTagsOfResourceResponse =
      zio.aws.dynamodb.model.ListTagsOfResourceResponse(
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def tags: Option[List[zio.aws.dynamodb.model.Tag.ReadOnly]]
    def nextToken: Option[NextTokenString]
    def getTags: ZIO[Any, AwsError, List[zio.aws.dynamodb.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getNextToken: ZIO[Any, AwsError, NextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceResponse
  ) extends zio.aws.dynamodb.model.ListTagsOfResourceResponse.ReadOnly {
    override val tags: Option[List[zio.aws.dynamodb.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.Tag.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextTokenString] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.dynamodb.model.primitives.NextTokenString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceResponse
  ): zio.aws.dynamodb.model.ListTagsOfResourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
