package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeContinuousBackupsResponse(
    continuousBackupsDescription: Option[
      zio.aws.dynamodb.model.ContinuousBackupsDescription
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DescribeContinuousBackupsResponse = {
    import DescribeContinuousBackupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DescribeContinuousBackupsResponse
      .builder()
      .optionallyWith(
        continuousBackupsDescription.map(value => value.buildAwsValue())
      )(_.continuousBackupsDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.DescribeContinuousBackupsResponse.ReadOnly =
    zio.aws.dynamodb.model.DescribeContinuousBackupsResponse
      .wrap(buildAwsValue())
}
object DescribeContinuousBackupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DescribeContinuousBackupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DescribeContinuousBackupsResponse =
      zio.aws.dynamodb.model.DescribeContinuousBackupsResponse(
        continuousBackupsDescription.map(value => value.asEditable)
      )
    def continuousBackupsDescription
        : Option[zio.aws.dynamodb.model.ContinuousBackupsDescription.ReadOnly]
    def getContinuousBackupsDescription: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ContinuousBackupsDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "continuousBackupsDescription",
      continuousBackupsDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeContinuousBackupsResponse
  ) extends zio.aws.dynamodb.model.DescribeContinuousBackupsResponse.ReadOnly {
    override val continuousBackupsDescription
        : Option[zio.aws.dynamodb.model.ContinuousBackupsDescription.ReadOnly] =
      scala
        .Option(impl.continuousBackupsDescription())
        .map(value =>
          zio.aws.dynamodb.model.ContinuousBackupsDescription.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeContinuousBackupsResponse
  ): zio.aws.dynamodb.model.DescribeContinuousBackupsResponse.ReadOnly =
    new Wrapper(impl)
}
