package zio.aws.dynamodb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{
  ExportNextToken,
  ListExportsMaxLimit,
  TableArn
}
import scala.jdk.CollectionConverters.*
final case class ListExportsRequest(
    tableArn: Option[TableArn] = None,
    maxResults: Option[ListExportsMaxLimit] = None,
    nextToken: Option[ExportNextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ListExportsRequest = {
    import ListExportsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ListExportsRequest
      .builder()
      .optionallyWith(
        tableArn.map(value => TableArn.unwrap(value): java.lang.String)
      )(_.tableArn)
      .optionallyWith(
        maxResults.map(value => ListExportsMaxLimit.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => ExportNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ListExportsRequest.ReadOnly =
    zio.aws.dynamodb.model.ListExportsRequest.wrap(buildAwsValue())
}
object ListExportsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ListExportsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ListExportsRequest =
      zio.aws.dynamodb.model.ListExportsRequest(
        tableArn.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def tableArn: Option[TableArn]
    def maxResults: Option[ListExportsMaxLimit]
    def nextToken: Option[ExportNextToken]
    def getTableArn: ZIO[Any, AwsError, TableArn] =
      AwsError.unwrapOptionField("tableArn", tableArn)
    def getMaxResults: ZIO[Any, AwsError, ListExportsMaxLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, ExportNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ListExportsRequest
  ) extends zio.aws.dynamodb.model.ListExportsRequest.ReadOnly {
    override val tableArn: Option[TableArn] = scala
      .Option(impl.tableArn())
      .map(value => zio.aws.dynamodb.model.primitives.TableArn(value))
    override val maxResults: Option[ListExportsMaxLimit] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.dynamodb.model.primitives.ListExportsMaxLimit(value)
      )
    override val nextToken: Option[ExportNextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.dynamodb.model.primitives.ExportNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ListExportsRequest
  ): zio.aws.dynamodb.model.ListExportsRequest.ReadOnly = new Wrapper(impl)
}
