package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.Date
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class TableClassSummary(
    tableClass: Option[zio.aws.dynamodb.model.TableClass] = None,
    lastUpdateDateTime: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.TableClassSummary = {
    import TableClassSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.TableClassSummary
      .builder()
      .optionallyWith(tableClass.map(value => value.unwrap))(_.tableClass)
      .optionallyWith(
        lastUpdateDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdateDateTime)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.TableClassSummary.ReadOnly =
    zio.aws.dynamodb.model.TableClassSummary.wrap(buildAwsValue())
}
object TableClassSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.TableClassSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.TableClassSummary =
      zio.aws.dynamodb.model.TableClassSummary(
        tableClass.map(value => value),
        lastUpdateDateTime.map(value => value)
      )
    def tableClass: Option[zio.aws.dynamodb.model.TableClass]
    def lastUpdateDateTime: Option[Date]
    def getTableClass: ZIO[Any, AwsError, zio.aws.dynamodb.model.TableClass] =
      AwsError.unwrapOptionField("tableClass", tableClass)
    def getLastUpdateDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdateDateTime", lastUpdateDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.TableClassSummary
  ) extends zio.aws.dynamodb.model.TableClassSummary.ReadOnly {
    override val tableClass: Option[zio.aws.dynamodb.model.TableClass] = scala
      .Option(impl.tableClass())
      .map(value => zio.aws.dynamodb.model.TableClass.wrap(value))
    override val lastUpdateDateTime: Option[Date] = scala
      .Option(impl.lastUpdateDateTime())
      .map(value => zio.aws.dynamodb.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.TableClassSummary
  ): zio.aws.dynamodb.model.TableClassSummary.ReadOnly = new Wrapper(impl)
}
