package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{KMSMasterKeyId, SSEEnabled}
import scala.jdk.CollectionConverters.*
final case class SSESpecification(
    enabled: Option[SSEEnabled] = None,
    sseType: Option[zio.aws.dynamodb.model.SSEType] = None,
    kmsMasterKeyId: Option[KMSMasterKeyId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.SSESpecification = {
    import SSESpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.SSESpecification
      .builder()
      .optionallyWith(
        enabled.map(value => SSEEnabled.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .optionallyWith(sseType.map(value => value.unwrap))(_.sseType)
      .optionallyWith(
        kmsMasterKeyId.map(value =>
          KMSMasterKeyId.unwrap(value): java.lang.String
        )
      )(_.kmsMasterKeyId)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.SSESpecification.ReadOnly =
    zio.aws.dynamodb.model.SSESpecification.wrap(buildAwsValue())
}
object SSESpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.SSESpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.SSESpecification =
      zio.aws.dynamodb.model.SSESpecification(
        enabled.map(value => value),
        sseType.map(value => value),
        kmsMasterKeyId.map(value => value)
      )
    def enabled: Option[SSEEnabled]
    def sseType: Option[zio.aws.dynamodb.model.SSEType]
    def kmsMasterKeyId: Option[KMSMasterKeyId]
    def getEnabled: ZIO[Any, AwsError, SSEEnabled] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getSseType: ZIO[Any, AwsError, zio.aws.dynamodb.model.SSEType] =
      AwsError.unwrapOptionField("sseType", sseType)
    def getKmsMasterKeyId: ZIO[Any, AwsError, KMSMasterKeyId] =
      AwsError.unwrapOptionField("kmsMasterKeyId", kmsMasterKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.SSESpecification
  ) extends zio.aws.dynamodb.model.SSESpecification.ReadOnly {
    override val enabled: Option[SSEEnabled] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.dynamodb.model.primitives.SSEEnabled(value))
    override val sseType: Option[zio.aws.dynamodb.model.SSEType] = scala
      .Option(impl.sseType())
      .map(value => zio.aws.dynamodb.model.SSEType.wrap(value))
    override val kmsMasterKeyId: Option[KMSMasterKeyId] = scala
      .Option(impl.kmsMasterKeyId())
      .map(value => zio.aws.dynamodb.model.primitives.KMSMasterKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.SSESpecification
  ): zio.aws.dynamodb.model.SSESpecification.ReadOnly = new Wrapper(impl)
}
