package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.PartiQLStatement
import scala.jdk.CollectionConverters.*
final case class ParameterizedStatement(
    statement: PartiQLStatement,
    parameters: Option[Iterable[zio.aws.dynamodb.model.AttributeValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ParameterizedStatement = {
    import ParameterizedStatement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ParameterizedStatement
      .builder()
      .statement(PartiQLStatement.unwrap(statement): java.lang.String)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ParameterizedStatement.ReadOnly =
    zio.aws.dynamodb.model.ParameterizedStatement.wrap(buildAwsValue())
}
object ParameterizedStatement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ParameterizedStatement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ParameterizedStatement =
      zio.aws.dynamodb.model.ParameterizedStatement(
        statement,
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def statement: PartiQLStatement
    def parameters: Option[List[zio.aws.dynamodb.model.AttributeValue.ReadOnly]]
    def getStatement: ZIO[Any, Nothing, PartiQLStatement] =
      ZIO.succeed(statement)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ParameterizedStatement
  ) extends zio.aws.dynamodb.model.ParameterizedStatement.ReadOnly {
    override val statement: PartiQLStatement =
      zio.aws.dynamodb.model.primitives.PartiQLStatement(impl.statement())
    override val parameters
        : Option[List[zio.aws.dynamodb.model.AttributeValue.ReadOnly]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.AttributeValue.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ParameterizedStatement
  ): zio.aws.dynamodb.model.ParameterizedStatement.ReadOnly = new Wrapper(impl)
}
