package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.StreamArn
import scala.jdk.CollectionConverters.*
final case class KinesisDataStreamDestination(
    streamArn: Option[StreamArn] = None,
    destinationStatus: Option[zio.aws.dynamodb.model.DestinationStatus] = None,
    destinationStatusDescription: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.KinesisDataStreamDestination = {
    import KinesisDataStreamDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.KinesisDataStreamDestination
      .builder()
      .optionallyWith(
        streamArn.map(value => StreamArn.unwrap(value): java.lang.String)
      )(_.streamArn)
      .optionallyWith(destinationStatus.map(value => value.unwrap))(
        _.destinationStatus
      )
      .optionallyWith(
        destinationStatusDescription.map(value => value: java.lang.String)
      )(_.destinationStatusDescription)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.KinesisDataStreamDestination.ReadOnly =
    zio.aws.dynamodb.model.KinesisDataStreamDestination.wrap(buildAwsValue())
}
object KinesisDataStreamDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.KinesisDataStreamDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.KinesisDataStreamDestination =
      zio.aws.dynamodb.model.KinesisDataStreamDestination(
        streamArn.map(value => value),
        destinationStatus.map(value => value),
        destinationStatusDescription.map(value => value)
      )
    def streamArn: Option[StreamArn]
    def destinationStatus: Option[zio.aws.dynamodb.model.DestinationStatus]
    def destinationStatusDescription: Option[String]
    def getStreamArn: ZIO[Any, AwsError, StreamArn] =
      AwsError.unwrapOptionField("streamArn", streamArn)
    def getDestinationStatus
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.DestinationStatus] =
      AwsError.unwrapOptionField("destinationStatus", destinationStatus)
    def getDestinationStatusDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "destinationStatusDescription",
        destinationStatusDescription
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.KinesisDataStreamDestination
  ) extends zio.aws.dynamodb.model.KinesisDataStreamDestination.ReadOnly {
    override val streamArn: Option[StreamArn] = scala
      .Option(impl.streamArn())
      .map(value => zio.aws.dynamodb.model.primitives.StreamArn(value))
    override val destinationStatus
        : Option[zio.aws.dynamodb.model.DestinationStatus] = scala
      .Option(impl.destinationStatus())
      .map(value => zio.aws.dynamodb.model.DestinationStatus.wrap(value))
    override val destinationStatusDescription: Option[String] = scala
      .Option(impl.destinationStatusDescription())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.KinesisDataStreamDestination
  ): zio.aws.dynamodb.model.KinesisDataStreamDestination.ReadOnly = new Wrapper(
    impl
  )
}
