package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.PositiveLongObject
import scala.jdk.CollectionConverters.*
final case class DescribeLimitsResponse(
    accountMaxReadCapacityUnits: Option[PositiveLongObject] = None,
    accountMaxWriteCapacityUnits: Option[PositiveLongObject] = None,
    tableMaxReadCapacityUnits: Option[PositiveLongObject] = None,
    tableMaxWriteCapacityUnits: Option[PositiveLongObject] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DescribeLimitsResponse = {
    import DescribeLimitsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DescribeLimitsResponse
      .builder()
      .optionallyWith(
        accountMaxReadCapacityUnits.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.accountMaxReadCapacityUnits)
      .optionallyWith(
        accountMaxWriteCapacityUnits.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.accountMaxWriteCapacityUnits)
      .optionallyWith(
        tableMaxReadCapacityUnits.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.tableMaxReadCapacityUnits)
      .optionallyWith(
        tableMaxWriteCapacityUnits.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.tableMaxWriteCapacityUnits)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.DescribeLimitsResponse.ReadOnly =
    zio.aws.dynamodb.model.DescribeLimitsResponse.wrap(buildAwsValue())
}
object DescribeLimitsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DescribeLimitsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DescribeLimitsResponse =
      zio.aws.dynamodb.model.DescribeLimitsResponse(
        accountMaxReadCapacityUnits.map(value => value),
        accountMaxWriteCapacityUnits.map(value => value),
        tableMaxReadCapacityUnits.map(value => value),
        tableMaxWriteCapacityUnits.map(value => value)
      )
    def accountMaxReadCapacityUnits: Option[PositiveLongObject]
    def accountMaxWriteCapacityUnits: Option[PositiveLongObject]
    def tableMaxReadCapacityUnits: Option[PositiveLongObject]
    def tableMaxWriteCapacityUnits: Option[PositiveLongObject]
    def getAccountMaxReadCapacityUnits: ZIO[Any, AwsError, PositiveLongObject] =
      AwsError.unwrapOptionField(
        "accountMaxReadCapacityUnits",
        accountMaxReadCapacityUnits
      )
    def getAccountMaxWriteCapacityUnits
        : ZIO[Any, AwsError, PositiveLongObject] = AwsError.unwrapOptionField(
      "accountMaxWriteCapacityUnits",
      accountMaxWriteCapacityUnits
    )
    def getTableMaxReadCapacityUnits: ZIO[Any, AwsError, PositiveLongObject] =
      AwsError.unwrapOptionField(
        "tableMaxReadCapacityUnits",
        tableMaxReadCapacityUnits
      )
    def getTableMaxWriteCapacityUnits: ZIO[Any, AwsError, PositiveLongObject] =
      AwsError.unwrapOptionField(
        "tableMaxWriteCapacityUnits",
        tableMaxWriteCapacityUnits
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeLimitsResponse
  ) extends zio.aws.dynamodb.model.DescribeLimitsResponse.ReadOnly {
    override val accountMaxReadCapacityUnits: Option[PositiveLongObject] = scala
      .Option(impl.accountMaxReadCapacityUnits())
      .map(value => zio.aws.dynamodb.model.primitives.PositiveLongObject(value))
    override val accountMaxWriteCapacityUnits: Option[PositiveLongObject] =
      scala
        .Option(impl.accountMaxWriteCapacityUnits())
        .map(value =>
          zio.aws.dynamodb.model.primitives.PositiveLongObject(value)
        )
    override val tableMaxReadCapacityUnits: Option[PositiveLongObject] = scala
      .Option(impl.tableMaxReadCapacityUnits())
      .map(value => zio.aws.dynamodb.model.primitives.PositiveLongObject(value))
    override val tableMaxWriteCapacityUnits: Option[PositiveLongObject] = scala
      .Option(impl.tableMaxWriteCapacityUnits())
      .map(value => zio.aws.dynamodb.model.primitives.PositiveLongObject(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeLimitsResponse
  ): zio.aws.dynamodb.model.DescribeLimitsResponse.ReadOnly = new Wrapper(impl)
}
