package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{
  TableName,
  BackupArn,
  BackupSizeBytes,
  Date,
  BackupCreationDateTime,
  BackupName,
  TableArn,
  TableId
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class BackupSummary(
    tableName: Option[TableName] = None,
    tableId: Option[TableId] = None,
    tableArn: Option[TableArn] = None,
    backupArn: Option[BackupArn] = None,
    backupName: Option[BackupName] = None,
    backupCreationDateTime: Option[BackupCreationDateTime] = None,
    backupExpiryDateTime: Option[Date] = None,
    backupStatus: Option[zio.aws.dynamodb.model.BackupStatus] = None,
    backupType: Option[zio.aws.dynamodb.model.BackupType] = None,
    backupSizeBytes: Option[BackupSizeBytes] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.BackupSummary = {
    import BackupSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.BackupSummary
      .builder()
      .optionallyWith(
        tableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(
        tableId.map(value => TableId.unwrap(value): java.lang.String)
      )(_.tableId)
      .optionallyWith(
        tableArn.map(value => TableArn.unwrap(value): java.lang.String)
      )(_.tableArn)
      .optionallyWith(
        backupArn.map(value => BackupArn.unwrap(value): java.lang.String)
      )(_.backupArn)
      .optionallyWith(
        backupName.map(value => BackupName.unwrap(value): java.lang.String)
      )(_.backupName)
      .optionallyWith(
        backupCreationDateTime.map(value =>
          BackupCreationDateTime.unwrap(value): Instant
        )
      )(_.backupCreationDateTime)
      .optionallyWith(
        backupExpiryDateTime.map(value => Date.unwrap(value): Instant)
      )(_.backupExpiryDateTime)
      .optionallyWith(backupStatus.map(value => value.unwrap))(_.backupStatus)
      .optionallyWith(backupType.map(value => value.unwrap))(_.backupType)
      .optionallyWith(
        backupSizeBytes.map(value =>
          BackupSizeBytes.unwrap(value): java.lang.Long
        )
      )(_.backupSizeBytes)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.BackupSummary.ReadOnly =
    zio.aws.dynamodb.model.BackupSummary.wrap(buildAwsValue())
}
object BackupSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.BackupSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.BackupSummary =
      zio.aws.dynamodb.model.BackupSummary(
        tableName.map(value => value),
        tableId.map(value => value),
        tableArn.map(value => value),
        backupArn.map(value => value),
        backupName.map(value => value),
        backupCreationDateTime.map(value => value),
        backupExpiryDateTime.map(value => value),
        backupStatus.map(value => value),
        backupType.map(value => value),
        backupSizeBytes.map(value => value)
      )
    def tableName: Option[TableName]
    def tableId: Option[TableId]
    def tableArn: Option[TableArn]
    def backupArn: Option[BackupArn]
    def backupName: Option[BackupName]
    def backupCreationDateTime: Option[BackupCreationDateTime]
    def backupExpiryDateTime: Option[Date]
    def backupStatus: Option[zio.aws.dynamodb.model.BackupStatus]
    def backupType: Option[zio.aws.dynamodb.model.BackupType]
    def backupSizeBytes: Option[BackupSizeBytes]
    def getTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getTableId: ZIO[Any, AwsError, TableId] =
      AwsError.unwrapOptionField("tableId", tableId)
    def getTableArn: ZIO[Any, AwsError, TableArn] =
      AwsError.unwrapOptionField("tableArn", tableArn)
    def getBackupArn: ZIO[Any, AwsError, BackupArn] =
      AwsError.unwrapOptionField("backupArn", backupArn)
    def getBackupName: ZIO[Any, AwsError, BackupName] =
      AwsError.unwrapOptionField("backupName", backupName)
    def getBackupCreationDateTime: ZIO[Any, AwsError, BackupCreationDateTime] =
      AwsError.unwrapOptionField(
        "backupCreationDateTime",
        backupCreationDateTime
      )
    def getBackupExpiryDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("backupExpiryDateTime", backupExpiryDateTime)
    def getBackupStatus
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.BackupStatus] =
      AwsError.unwrapOptionField("backupStatus", backupStatus)
    def getBackupType: ZIO[Any, AwsError, zio.aws.dynamodb.model.BackupType] =
      AwsError.unwrapOptionField("backupType", backupType)
    def getBackupSizeBytes: ZIO[Any, AwsError, BackupSizeBytes] =
      AwsError.unwrapOptionField("backupSizeBytes", backupSizeBytes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.BackupSummary
  ) extends zio.aws.dynamodb.model.BackupSummary.ReadOnly {
    override val tableName: Option[TableName] = scala
      .Option(impl.tableName())
      .map(value => zio.aws.dynamodb.model.primitives.TableName(value))
    override val tableId: Option[TableId] = scala
      .Option(impl.tableId())
      .map(value => zio.aws.dynamodb.model.primitives.TableId(value))
    override val tableArn: Option[TableArn] = scala
      .Option(impl.tableArn())
      .map(value => zio.aws.dynamodb.model.primitives.TableArn(value))
    override val backupArn: Option[BackupArn] = scala
      .Option(impl.backupArn())
      .map(value => zio.aws.dynamodb.model.primitives.BackupArn(value))
    override val backupName: Option[BackupName] = scala
      .Option(impl.backupName())
      .map(value => zio.aws.dynamodb.model.primitives.BackupName(value))
    override val backupCreationDateTime: Option[BackupCreationDateTime] = scala
      .Option(impl.backupCreationDateTime())
      .map(value =>
        zio.aws.dynamodb.model.primitives.BackupCreationDateTime(value)
      )
    override val backupExpiryDateTime: Option[Date] = scala
      .Option(impl.backupExpiryDateTime())
      .map(value => zio.aws.dynamodb.model.primitives.Date(value))
    override val backupStatus: Option[zio.aws.dynamodb.model.BackupStatus] =
      scala
        .Option(impl.backupStatus())
        .map(value => zio.aws.dynamodb.model.BackupStatus.wrap(value))
    override val backupType: Option[zio.aws.dynamodb.model.BackupType] = scala
      .Option(impl.backupType())
      .map(value => zio.aws.dynamodb.model.BackupType.wrap(value))
    override val backupSizeBytes: Option[BackupSizeBytes] = scala
      .Option(impl.backupSizeBytes())
      .map(value => zio.aws.dynamodb.model.primitives.BackupSizeBytes(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.BackupSummary
  ): zio.aws.dynamodb.model.BackupSummary.ReadOnly = new Wrapper(impl)
}
