package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{
  AutoScalingRoleArn,
  BooleanObject,
  PositiveLongObject
}
import scala.jdk.CollectionConverters.*
final case class AutoScalingSettingsUpdate(
    minimumUnits: Option[PositiveLongObject] = None,
    maximumUnits: Option[PositiveLongObject] = None,
    autoScalingDisabled: Option[BooleanObject] = None,
    autoScalingRoleArn: Option[AutoScalingRoleArn] = None,
    scalingPolicyUpdate: Option[
      zio.aws.dynamodb.model.AutoScalingPolicyUpdate
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsUpdate = {
    import AutoScalingSettingsUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsUpdate
      .builder()
      .optionallyWith(
        minimumUnits.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.minimumUnits)
      .optionallyWith(
        maximumUnits.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.maximumUnits)
      .optionallyWith(
        autoScalingDisabled.map(value =>
          BooleanObject.unwrap(value): java.lang.Boolean
        )
      )(_.autoScalingDisabled)
      .optionallyWith(
        autoScalingRoleArn.map(value =>
          AutoScalingRoleArn.unwrap(value): java.lang.String
        )
      )(_.autoScalingRoleArn)
      .optionallyWith(scalingPolicyUpdate.map(value => value.buildAwsValue()))(
        _.scalingPolicyUpdate
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly =
    zio.aws.dynamodb.model.AutoScalingSettingsUpdate.wrap(buildAwsValue())
}
object AutoScalingSettingsUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.AutoScalingSettingsUpdate =
      zio.aws.dynamodb.model.AutoScalingSettingsUpdate(
        minimumUnits.map(value => value),
        maximumUnits.map(value => value),
        autoScalingDisabled.map(value => value),
        autoScalingRoleArn.map(value => value),
        scalingPolicyUpdate.map(value => value.asEditable)
      )
    def minimumUnits: Option[PositiveLongObject]
    def maximumUnits: Option[PositiveLongObject]
    def autoScalingDisabled: Option[BooleanObject]
    def autoScalingRoleArn: Option[AutoScalingRoleArn]
    def scalingPolicyUpdate
        : Option[zio.aws.dynamodb.model.AutoScalingPolicyUpdate.ReadOnly]
    def getMinimumUnits: ZIO[Any, AwsError, PositiveLongObject] =
      AwsError.unwrapOptionField("minimumUnits", minimumUnits)
    def getMaximumUnits: ZIO[Any, AwsError, PositiveLongObject] =
      AwsError.unwrapOptionField("maximumUnits", maximumUnits)
    def getAutoScalingDisabled: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("autoScalingDisabled", autoScalingDisabled)
    def getAutoScalingRoleArn: ZIO[Any, AwsError, AutoScalingRoleArn] =
      AwsError.unwrapOptionField("autoScalingRoleArn", autoScalingRoleArn)
    def getScalingPolicyUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.AutoScalingPolicyUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("scalingPolicyUpdate", scalingPolicyUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsUpdate
  ) extends zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly {
    override val minimumUnits: Option[PositiveLongObject] = scala
      .Option(impl.minimumUnits())
      .map(value => zio.aws.dynamodb.model.primitives.PositiveLongObject(value))
    override val maximumUnits: Option[PositiveLongObject] = scala
      .Option(impl.maximumUnits())
      .map(value => zio.aws.dynamodb.model.primitives.PositiveLongObject(value))
    override val autoScalingDisabled: Option[BooleanObject] = scala
      .Option(impl.autoScalingDisabled())
      .map(value => zio.aws.dynamodb.model.primitives.BooleanObject(value))
    override val autoScalingRoleArn: Option[AutoScalingRoleArn] = scala
      .Option(impl.autoScalingRoleArn())
      .map(value => zio.aws.dynamodb.model.primitives.AutoScalingRoleArn(value))
    override val scalingPolicyUpdate
        : Option[zio.aws.dynamodb.model.AutoScalingPolicyUpdate.ReadOnly] =
      scala
        .Option(impl.scalingPolicyUpdate())
        .map(value =>
          zio.aws.dynamodb.model.AutoScalingPolicyUpdate.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsUpdate
  ): zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly = new Wrapper(
    impl
  )
}
