package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateTableReplicaAutoScalingResponse(
    tableAutoScalingDescription: Option[
      zio.aws.dynamodb.model.TableAutoScalingDescription
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.UpdateTableReplicaAutoScalingResponse = {
    import UpdateTableReplicaAutoScalingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.UpdateTableReplicaAutoScalingResponse
      .builder()
      .optionallyWith(
        tableAutoScalingDescription.map(value => value.buildAwsValue())
      )(_.tableAutoScalingDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.UpdateTableReplicaAutoScalingResponse.ReadOnly =
    zio.aws.dynamodb.model.UpdateTableReplicaAutoScalingResponse
      .wrap(buildAwsValue())
}
object UpdateTableReplicaAutoScalingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.UpdateTableReplicaAutoScalingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dynamodb.model.UpdateTableReplicaAutoScalingResponse =
      zio.aws.dynamodb.model.UpdateTableReplicaAutoScalingResponse(
        tableAutoScalingDescription.map(value => value.asEditable)
      )
    def tableAutoScalingDescription
        : Option[zio.aws.dynamodb.model.TableAutoScalingDescription.ReadOnly]
    def getTableAutoScalingDescription: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.TableAutoScalingDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "tableAutoScalingDescription",
      tableAutoScalingDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateTableReplicaAutoScalingResponse
  ) extends zio.aws.dynamodb.model.UpdateTableReplicaAutoScalingResponse.ReadOnly {
    override val tableAutoScalingDescription
        : Option[zio.aws.dynamodb.model.TableAutoScalingDescription.ReadOnly] =
      scala
        .Option(impl.tableAutoScalingDescription())
        .map(value =>
          zio.aws.dynamodb.model.TableAutoScalingDescription.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateTableReplicaAutoScalingResponse
  ): zio.aws.dynamodb.model.UpdateTableReplicaAutoScalingResponse.ReadOnly =
    new Wrapper(impl)
}
