package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.StreamEnabled
import scala.jdk.CollectionConverters.*
final case class StreamSpecification(
    streamEnabled: StreamEnabled,
    streamViewType: Option[zio.aws.dynamodb.model.StreamViewType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.StreamSpecification = {
    import StreamSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.StreamSpecification
      .builder()
      .streamEnabled(StreamEnabled.unwrap(streamEnabled): java.lang.Boolean)
      .optionallyWith(streamViewType.map(value => value.unwrap))(
        _.streamViewType
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.StreamSpecification.ReadOnly =
    zio.aws.dynamodb.model.StreamSpecification.wrap(buildAwsValue())
}
object StreamSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.StreamSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.StreamSpecification =
      zio.aws.dynamodb.model
        .StreamSpecification(streamEnabled, streamViewType.map(value => value))
    def streamEnabled: StreamEnabled
    def streamViewType: Option[zio.aws.dynamodb.model.StreamViewType]
    def getStreamEnabled: ZIO[Any, Nothing, StreamEnabled] =
      ZIO.succeed(streamEnabled)
    def getStreamViewType
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.StreamViewType] =
      AwsError.unwrapOptionField("streamViewType", streamViewType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.StreamSpecification
  ) extends zio.aws.dynamodb.model.StreamSpecification.ReadOnly {
    override val streamEnabled: StreamEnabled =
      zio.aws.dynamodb.model.primitives.StreamEnabled(impl.streamEnabled())
    override val streamViewType: Option[zio.aws.dynamodb.model.StreamViewType] =
      scala
        .Option(impl.streamViewType())
        .map(value => zio.aws.dynamodb.model.StreamViewType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.StreamSpecification
  ): zio.aws.dynamodb.model.StreamSpecification.ReadOnly = new Wrapper(impl)
}
