package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters.*
sealed trait S3SseAlgorithm {
  def unwrap: software.amazon.awssdk.services.dynamodb.model.S3SseAlgorithm
}
object S3SseAlgorithm {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.S3SseAlgorithm
  ): zio.aws.dynamodb.model.S3SseAlgorithm = value match {
    case software.amazon.awssdk.services.dynamodb.model.S3SseAlgorithm.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.S3SseAlgorithm.AES256 =>
      val r = AES256
      r
    case software.amazon.awssdk.services.dynamodb.model.S3SseAlgorithm.KMS =>
      val r = KMS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dynamodb.model.S3SseAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.S3SseAlgorithm =
      software.amazon.awssdk.services.dynamodb.model.S3SseAlgorithm.UNKNOWN_TO_SDK_VERSION
  }
  case object AES256 extends zio.aws.dynamodb.model.S3SseAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.S3SseAlgorithm =
      software.amazon.awssdk.services.dynamodb.model.S3SseAlgorithm.AES256
  }
  case object KMS extends zio.aws.dynamodb.model.S3SseAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.S3SseAlgorithm =
      software.amazon.awssdk.services.dynamodb.model.S3SseAlgorithm.KMS
  }
}
