package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.IndexName
import scala.jdk.CollectionConverters.*
final case class LocalSecondaryIndex(
    indexName: IndexName,
    keySchema: Iterable[zio.aws.dynamodb.model.KeySchemaElement],
    projection: zio.aws.dynamodb.model.Projection
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndex = {
    import LocalSecondaryIndex.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndex
      .builder()
      .indexName(IndexName.unwrap(indexName): java.lang.String)
      .keySchema(keySchema.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .projection(projection.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.LocalSecondaryIndex.ReadOnly =
    zio.aws.dynamodb.model.LocalSecondaryIndex.wrap(buildAwsValue())
}
object LocalSecondaryIndex {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndex
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.LocalSecondaryIndex =
      zio.aws.dynamodb.model.LocalSecondaryIndex(
        indexName,
        keySchema.map { item =>
          item.asEditable
        },
        projection.asEditable
      )
    def indexName: IndexName
    def keySchema: List[zio.aws.dynamodb.model.KeySchemaElement.ReadOnly]
    def projection: zio.aws.dynamodb.model.Projection.ReadOnly
    def getIndexName: ZIO[Any, Nothing, IndexName] = ZIO.succeed(indexName)
    def getKeySchema: ZIO[Any, Nothing, List[
      zio.aws.dynamodb.model.KeySchemaElement.ReadOnly
    ]] = ZIO.succeed(keySchema)
    def getProjection
        : ZIO[Any, Nothing, zio.aws.dynamodb.model.Projection.ReadOnly] =
      ZIO.succeed(projection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndex
  ) extends zio.aws.dynamodb.model.LocalSecondaryIndex.ReadOnly {
    override val indexName: IndexName =
      zio.aws.dynamodb.model.primitives.IndexName(impl.indexName())
    override val keySchema
        : List[zio.aws.dynamodb.model.KeySchemaElement.ReadOnly] = impl
      .keySchema()
      .asScala
      .map { item =>
        zio.aws.dynamodb.model.KeySchemaElement.wrap(item)
      }
      .toList
    override val projection: zio.aws.dynamodb.model.Projection.ReadOnly =
      zio.aws.dynamodb.model.Projection.wrap(impl.projection())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndex
  ): zio.aws.dynamodb.model.LocalSecondaryIndex.ReadOnly = new Wrapper(impl)
}
