package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.IndexName
import scala.jdk.CollectionConverters.*
final case class GlobalSecondaryIndexInfo(
    indexName: Option[IndexName] = None,
    keySchema: Option[Iterable[zio.aws.dynamodb.model.KeySchemaElement]] = None,
    projection: Option[zio.aws.dynamodb.model.Projection] = None,
    provisionedThroughput: Option[
      zio.aws.dynamodb.model.ProvisionedThroughput
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexInfo = {
    import GlobalSecondaryIndexInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexInfo
      .builder()
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(
        keySchema.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keySchema)
      .optionallyWith(projection.map(value => value.buildAwsValue()))(
        _.projection
      )
      .optionallyWith(
        provisionedThroughput.map(value => value.buildAwsValue())
      )(_.provisionedThroughput)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.GlobalSecondaryIndexInfo.ReadOnly =
    zio.aws.dynamodb.model.GlobalSecondaryIndexInfo.wrap(buildAwsValue())
}
object GlobalSecondaryIndexInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.GlobalSecondaryIndexInfo =
      zio.aws.dynamodb.model.GlobalSecondaryIndexInfo(
        indexName.map(value => value),
        keySchema.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        projection.map(value => value.asEditable),
        provisionedThroughput.map(value => value.asEditable)
      )
    def indexName: Option[IndexName]
    def keySchema
        : Option[List[zio.aws.dynamodb.model.KeySchemaElement.ReadOnly]]
    def projection: Option[zio.aws.dynamodb.model.Projection.ReadOnly]
    def provisionedThroughput
        : Option[zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly]
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getKeySchema: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.KeySchemaElement.ReadOnly
    ]] = AwsError.unwrapOptionField("keySchema", keySchema)
    def getProjection
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.Projection.ReadOnly] =
      AwsError.unwrapOptionField("projection", projection)
    def getProvisionedThroughput: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly
    ] =
      AwsError.unwrapOptionField("provisionedThroughput", provisionedThroughput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexInfo
  ) extends zio.aws.dynamodb.model.GlobalSecondaryIndexInfo.ReadOnly {
    override val indexName: Option[IndexName] = scala
      .Option(impl.indexName())
      .map(value => zio.aws.dynamodb.model.primitives.IndexName(value))
    override val keySchema
        : Option[List[zio.aws.dynamodb.model.KeySchemaElement.ReadOnly]] = scala
      .Option(impl.keySchema())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.KeySchemaElement.wrap(item)
        }.toList
      )
    override val projection
        : Option[zio.aws.dynamodb.model.Projection.ReadOnly] = scala
      .Option(impl.projection())
      .map(value => zio.aws.dynamodb.model.Projection.wrap(value))
    override val provisionedThroughput
        : Option[zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly] = scala
      .Option(impl.provisionedThroughput())
      .map(value => zio.aws.dynamodb.model.ProvisionedThroughput.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexInfo
  ): zio.aws.dynamodb.model.GlobalSecondaryIndexInfo.ReadOnly = new Wrapper(
    impl
  )
}
