package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{
  TableName,
  ProjectionExpression,
  AttributeName,
  ConsistentRead,
  ExpressionAttributeNameVariable
}
import scala.jdk.CollectionConverters.*
final case class GetItemRequest(
    tableName: TableName,
    key: Map[AttributeName, zio.aws.dynamodb.model.AttributeValue],
    attributesToGet: Option[Iterable[AttributeName]] = None,
    consistentRead: Option[ConsistentRead] = None,
    returnConsumedCapacity: Option[
      zio.aws.dynamodb.model.ReturnConsumedCapacity
    ] = None,
    projectionExpression: Option[ProjectionExpression] = None,
    expressionAttributeNames: Option[
      Map[ExpressionAttributeNameVariable, AttributeName]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.GetItemRequest = {
    import GetItemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.GetItemRequest
      .builder()
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .key(
        key
          .map({ case (key, value) =>
            (AttributeName.unwrap(key): java.lang.String) -> value
              .buildAwsValue()
          })
          .asJava
      )
      .optionallyWith(
        attributesToGet.map(value =>
          value.map { item =>
            AttributeName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.attributesToGet)
      .optionallyWith(
        consistentRead.map(value =>
          ConsistentRead.unwrap(value): java.lang.Boolean
        )
      )(_.consistentRead)
      .optionallyWith(returnConsumedCapacity.map(value => value.unwrap))(
        _.returnConsumedCapacity
      )
      .optionallyWith(
        projectionExpression.map(value =>
          ProjectionExpression.unwrap(value): java.lang.String
        )
      )(_.projectionExpression)
      .optionallyWith(
        expressionAttributeNames.map(value =>
          value
            .map({ case (key, value) =>
              (ExpressionAttributeNameVariable
                .unwrap(key): java.lang.String) -> (AttributeName
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.expressionAttributeNames)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.GetItemRequest.ReadOnly =
    zio.aws.dynamodb.model.GetItemRequest.wrap(buildAwsValue())
}
object GetItemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.GetItemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.GetItemRequest =
      zio.aws.dynamodb.model.GetItemRequest(
        tableName,
        key.map({ case (key, value) =>
          key -> value.asEditable
        }),
        attributesToGet.map(value => value),
        consistentRead.map(value => value),
        returnConsumedCapacity.map(value => value),
        projectionExpression.map(value => value),
        expressionAttributeNames.map(value => value)
      )
    def tableName: TableName
    def key: Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    def attributesToGet: Option[List[AttributeName]]
    def consistentRead: Option[ConsistentRead]
    def returnConsumedCapacity
        : Option[zio.aws.dynamodb.model.ReturnConsumedCapacity]
    def projectionExpression: Option[ProjectionExpression]
    def expressionAttributeNames
        : Option[Map[ExpressionAttributeNameVariable, AttributeName]]
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getKey: ZIO[Any, Nothing, Map[
      AttributeName,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = ZIO.succeed(key)
    def getAttributesToGet: ZIO[Any, AwsError, List[AttributeName]] =
      AwsError.unwrapOptionField("attributesToGet", attributesToGet)
    def getConsistentRead: ZIO[Any, AwsError, ConsistentRead] =
      AwsError.unwrapOptionField("consistentRead", consistentRead)
    def getReturnConsumedCapacity
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ReturnConsumedCapacity] =
      AwsError.unwrapOptionField(
        "returnConsumedCapacity",
        returnConsumedCapacity
      )
    def getProjectionExpression: ZIO[Any, AwsError, ProjectionExpression] =
      AwsError.unwrapOptionField("projectionExpression", projectionExpression)
    def getExpressionAttributeNames: ZIO[Any, AwsError, Map[
      ExpressionAttributeNameVariable,
      AttributeName
    ]] = AwsError.unwrapOptionField(
      "expressionAttributeNames",
      expressionAttributeNames
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.GetItemRequest
  ) extends zio.aws.dynamodb.model.GetItemRequest.ReadOnly {
    override val tableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.tableName())
    override val key
        : Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly] =
      impl
        .key()
        .asScala
        .map({ case (key, value) =>
          zio.aws.dynamodb.model.primitives.AttributeName(
            key
          ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
        })
        .toMap
    override val attributesToGet: Option[List[AttributeName]] = scala
      .Option(impl.attributesToGet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.primitives.AttributeName(item)
        }.toList
      )
    override val consistentRead: Option[ConsistentRead] = scala
      .Option(impl.consistentRead())
      .map(value => zio.aws.dynamodb.model.primitives.ConsistentRead(value))
    override val returnConsumedCapacity
        : Option[zio.aws.dynamodb.model.ReturnConsumedCapacity] = scala
      .Option(impl.returnConsumedCapacity())
      .map(value => zio.aws.dynamodb.model.ReturnConsumedCapacity.wrap(value))
    override val projectionExpression: Option[ProjectionExpression] = scala
      .Option(impl.projectionExpression())
      .map(value =>
        zio.aws.dynamodb.model.primitives.ProjectionExpression(value)
      )
    override val expressionAttributeNames
        : Option[Map[ExpressionAttributeNameVariable, AttributeName]] = scala
      .Option(impl.expressionAttributeNames())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.ExpressionAttributeNameVariable(
              key
            ) -> zio.aws.dynamodb.model.primitives.AttributeName(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.GetItemRequest
  ): zio.aws.dynamodb.model.GetItemRequest.ReadOnly = new Wrapper(impl)
}
