package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.{StreamArn, TableName}
import scala.jdk.CollectionConverters.*
final case class EnableKinesisStreamingDestinationRequest(
    tableName: TableName,
    streamArn: StreamArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingDestinationRequest = {
    import EnableKinesisStreamingDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingDestinationRequest
      .builder()
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .streamArn(StreamArn.unwrap(streamArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.EnableKinesisStreamingDestinationRequest.ReadOnly =
    zio.aws.dynamodb.model.EnableKinesisStreamingDestinationRequest
      .wrap(buildAwsValue())
}
object EnableKinesisStreamingDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dynamodb.model.EnableKinesisStreamingDestinationRequest =
      zio.aws.dynamodb.model
        .EnableKinesisStreamingDestinationRequest(tableName, streamArn)
    def tableName: TableName
    def streamArn: StreamArn
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getStreamArn: ZIO[Any, Nothing, StreamArn] = ZIO.succeed(streamArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingDestinationRequest
  ) extends zio.aws.dynamodb.model.EnableKinesisStreamingDestinationRequest.ReadOnly {
    override val tableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.tableName())
    override val streamArn: StreamArn =
      zio.aws.dynamodb.model.primitives.StreamArn(impl.streamArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingDestinationRequest
  ): zio.aws.dynamodb.model.EnableKinesisStreamingDestinationRequest.ReadOnly =
    new Wrapper(impl)
}
