package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.IndexName
import scala.jdk.CollectionConverters.*
final case class ReplicaGlobalSecondaryIndexAutoScalingDescription(
    indexName: Option[IndexName] = None,
    indexStatus: Option[zio.aws.dynamodb.model.IndexStatus] = None,
    provisionedReadCapacityAutoScalingSettings: Option[
      zio.aws.dynamodb.model.AutoScalingSettingsDescription
    ] = None,
    provisionedWriteCapacityAutoScalingSettings: Option[
      zio.aws.dynamodb.model.AutoScalingSettingsDescription
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingDescription = {
    import ReplicaGlobalSecondaryIndexAutoScalingDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingDescription
      .builder()
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(indexStatus.map(value => value.unwrap))(_.indexStatus)
      .optionallyWith(
        provisionedReadCapacityAutoScalingSettings.map(value =>
          value.buildAwsValue()
        )
      )(_.provisionedReadCapacityAutoScalingSettings)
      .optionallyWith(
        provisionedWriteCapacityAutoScalingSettings.map(value =>
          value.buildAwsValue()
        )
      )(_.provisionedWriteCapacityAutoScalingSettings)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingDescription.ReadOnly =
    zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingDescription
      .wrap(buildAwsValue())
}
object ReplicaGlobalSecondaryIndexAutoScalingDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingDescription =
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingDescription(
        indexName.map(value => value),
        indexStatus.map(value => value),
        provisionedReadCapacityAutoScalingSettings.map(value =>
          value.asEditable
        ),
        provisionedWriteCapacityAutoScalingSettings.map(value =>
          value.asEditable
        )
      )
    def indexName: Option[IndexName]
    def indexStatus: Option[zio.aws.dynamodb.model.IndexStatus]
    def provisionedReadCapacityAutoScalingSettings
        : Option[zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly]
    def provisionedWriteCapacityAutoScalingSettings
        : Option[zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly]
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getIndexStatus: ZIO[Any, AwsError, zio.aws.dynamodb.model.IndexStatus] =
      AwsError.unwrapOptionField("indexStatus", indexStatus)
    def getProvisionedReadCapacityAutoScalingSettings: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisionedReadCapacityAutoScalingSettings",
      provisionedReadCapacityAutoScalingSettings
    )
    def getProvisionedWriteCapacityAutoScalingSettings: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisionedWriteCapacityAutoScalingSettings",
      provisionedWriteCapacityAutoScalingSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingDescription
  ) extends zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingDescription.ReadOnly {
    override val indexName: Option[IndexName] = scala
      .Option(impl.indexName())
      .map(value => zio.aws.dynamodb.model.primitives.IndexName(value))
    override val indexStatus: Option[zio.aws.dynamodb.model.IndexStatus] = scala
      .Option(impl.indexStatus())
      .map(value => zio.aws.dynamodb.model.IndexStatus.wrap(value))
    override val provisionedReadCapacityAutoScalingSettings: Option[
      zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly
    ] = scala
      .Option(impl.provisionedReadCapacityAutoScalingSettings())
      .map(value =>
        zio.aws.dynamodb.model.AutoScalingSettingsDescription.wrap(value)
      )
    override val provisionedWriteCapacityAutoScalingSettings: Option[
      zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly
    ] = scala
      .Option(impl.provisionedWriteCapacityAutoScalingSettings())
      .map(value =>
        zio.aws.dynamodb.model.AutoScalingSettingsDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingDescription
  ): zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingDescription.ReadOnly =
    new Wrapper(impl)
}
