package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.IndexName
import scala.jdk.CollectionConverters.*
final case class GlobalSecondaryIndexAutoScalingUpdate(
    indexName: Option[IndexName] = None,
    provisionedWriteCapacityAutoScalingUpdate: Option[
      zio.aws.dynamodb.model.AutoScalingSettingsUpdate
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexAutoScalingUpdate = {
    import GlobalSecondaryIndexAutoScalingUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexAutoScalingUpdate
      .builder()
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(
        provisionedWriteCapacityAutoScalingUpdate.map(value =>
          value.buildAwsValue()
        )
      )(_.provisionedWriteCapacityAutoScalingUpdate)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.GlobalSecondaryIndexAutoScalingUpdate.ReadOnly =
    zio.aws.dynamodb.model.GlobalSecondaryIndexAutoScalingUpdate
      .wrap(buildAwsValue())
}
object GlobalSecondaryIndexAutoScalingUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexAutoScalingUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dynamodb.model.GlobalSecondaryIndexAutoScalingUpdate =
      zio.aws.dynamodb.model.GlobalSecondaryIndexAutoScalingUpdate(
        indexName.map(value => value),
        provisionedWriteCapacityAutoScalingUpdate.map(value => value.asEditable)
      )
    def indexName: Option[IndexName]
    def provisionedWriteCapacityAutoScalingUpdate
        : Option[zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly]
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getProvisionedWriteCapacityAutoScalingUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisionedWriteCapacityAutoScalingUpdate",
      provisionedWriteCapacityAutoScalingUpdate
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexAutoScalingUpdate
  ) extends zio.aws.dynamodb.model.GlobalSecondaryIndexAutoScalingUpdate.ReadOnly {
    override val indexName: Option[IndexName] = scala
      .Option(impl.indexName())
      .map(value => zio.aws.dynamodb.model.primitives.IndexName(value))
    override val provisionedWriteCapacityAutoScalingUpdate
        : Option[zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly] =
      scala
        .Option(impl.provisionedWriteCapacityAutoScalingUpdate())
        .map(value =>
          zio.aws.dynamodb.model.AutoScalingSettingsUpdate.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexAutoScalingUpdate
  ): zio.aws.dynamodb.model.GlobalSecondaryIndexAutoScalingUpdate.ReadOnly =
    new Wrapper(impl)
}
