package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Condition(
    attributeValueList: Option[
      Iterable[zio.aws.dynamodb.model.AttributeValue]
    ] = None,
    comparisonOperator: zio.aws.dynamodb.model.ComparisonOperator
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.Condition = {
    import Condition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.Condition
      .builder()
      .optionallyWith(
        attributeValueList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributeValueList)
      .comparisonOperator(comparisonOperator.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.Condition.ReadOnly =
    zio.aws.dynamodb.model.Condition.wrap(buildAwsValue())
}
object Condition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.Condition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.Condition =
      zio.aws.dynamodb.model.Condition(
        attributeValueList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        comparisonOperator
      )
    def attributeValueList
        : Option[List[zio.aws.dynamodb.model.AttributeValue.ReadOnly]]
    def comparisonOperator: zio.aws.dynamodb.model.ComparisonOperator
    def getAttributeValueList: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("attributeValueList", attributeValueList)
    def getComparisonOperator
        : ZIO[Any, Nothing, zio.aws.dynamodb.model.ComparisonOperator] =
      ZIO.succeed(comparisonOperator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.Condition
  ) extends zio.aws.dynamodb.model.Condition.ReadOnly {
    override val attributeValueList
        : Option[List[zio.aws.dynamodb.model.AttributeValue.ReadOnly]] = scala
      .Option(impl.attributeValueList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.AttributeValue.wrap(item)
        }.toList
      )
    override val comparisonOperator: zio.aws.dynamodb.model.ComparisonOperator =
      zio.aws.dynamodb.model.ComparisonOperator.wrap(impl.comparisonOperator())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.Condition
  ): zio.aws.dynamodb.model.Condition.ReadOnly = new Wrapper(impl)
}
