package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class WriteRequest(
    putRequest: Optional[zio.aws.dynamodb.model.PutRequest] = Optional.Absent,
    deleteRequest: Optional[zio.aws.dynamodb.model.DeleteRequest] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.WriteRequest = {
    import WriteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.WriteRequest
      .builder()
      .optionallyWith(putRequest.map(value => value.buildAwsValue()))(
        _.putRequest
      )
      .optionallyWith(deleteRequest.map(value => value.buildAwsValue()))(
        _.deleteRequest
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.WriteRequest.ReadOnly =
    zio.aws.dynamodb.model.WriteRequest.wrap(buildAwsValue())
}
object WriteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.WriteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.WriteRequest =
      zio.aws.dynamodb.model.WriteRequest(
        putRequest.map(value => value.asEditable),
        deleteRequest.map(value => value.asEditable)
      )
    def putRequest: Optional[zio.aws.dynamodb.model.PutRequest.ReadOnly]
    def deleteRequest: Optional[zio.aws.dynamodb.model.DeleteRequest.ReadOnly]
    def getPutRequest
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.PutRequest.ReadOnly] =
      AwsError.unwrapOptionField("putRequest", putRequest)
    def getDeleteRequest
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.DeleteRequest.ReadOnly] =
      AwsError.unwrapOptionField("deleteRequest", deleteRequest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.WriteRequest
  ) extends zio.aws.dynamodb.model.WriteRequest.ReadOnly {
    override val putRequest
        : Optional[zio.aws.dynamodb.model.PutRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.putRequest())
        .map(value => zio.aws.dynamodb.model.PutRequest.wrap(value))
    override val deleteRequest
        : Optional[zio.aws.dynamodb.model.DeleteRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deleteRequest())
        .map(value => zio.aws.dynamodb.model.DeleteRequest.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.WriteRequest
  ): zio.aws.dynamodb.model.WriteRequest.ReadOnly = new Wrapper(impl)
}
