package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.ClientToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImportTableRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    s3BucketSource: zio.aws.dynamodb.model.S3BucketSource,
    inputFormat: zio.aws.dynamodb.model.InputFormat,
    inputFormatOptions: Optional[zio.aws.dynamodb.model.InputFormatOptions] =
      Optional.Absent,
    inputCompressionType: Optional[
      zio.aws.dynamodb.model.InputCompressionType
    ] = Optional.Absent,
    tableCreationParameters: zio.aws.dynamodb.model.TableCreationParameters
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ImportTableRequest = {
    import ImportTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ImportTableRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .s3BucketSource(s3BucketSource.buildAwsValue())
      .inputFormat(inputFormat.unwrap)
      .optionallyWith(inputFormatOptions.map(value => value.buildAwsValue()))(
        _.inputFormatOptions
      )
      .optionallyWith(inputCompressionType.map(value => value.unwrap))(
        _.inputCompressionType
      )
      .tableCreationParameters(tableCreationParameters.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ImportTableRequest.ReadOnly =
    zio.aws.dynamodb.model.ImportTableRequest.wrap(buildAwsValue())
}
object ImportTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ImportTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ImportTableRequest =
      zio.aws.dynamodb.model.ImportTableRequest(
        clientToken.map(value => value),
        s3BucketSource.asEditable,
        inputFormat,
        inputFormatOptions.map(value => value.asEditable),
        inputCompressionType.map(value => value),
        tableCreationParameters.asEditable
      )
    def clientToken: Optional[ClientToken]
    def s3BucketSource: zio.aws.dynamodb.model.S3BucketSource.ReadOnly
    def inputFormat: zio.aws.dynamodb.model.InputFormat
    def inputFormatOptions
        : Optional[zio.aws.dynamodb.model.InputFormatOptions.ReadOnly]
    def inputCompressionType
        : Optional[zio.aws.dynamodb.model.InputCompressionType]
    def tableCreationParameters
        : zio.aws.dynamodb.model.TableCreationParameters.ReadOnly
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getS3BucketSource
        : ZIO[Any, Nothing, zio.aws.dynamodb.model.S3BucketSource.ReadOnly] =
      ZIO.succeed(s3BucketSource)
    def getInputFormat: ZIO[Any, Nothing, zio.aws.dynamodb.model.InputFormat] =
      ZIO.succeed(inputFormat)
    def getInputFormatOptions: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.InputFormatOptions.ReadOnly
    ] = AwsError.unwrapOptionField("inputFormatOptions", inputFormatOptions)
    def getInputCompressionType
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.InputCompressionType] =
      AwsError.unwrapOptionField("inputCompressionType", inputCompressionType)
    def getTableCreationParameters: ZIO[
      Any,
      Nothing,
      zio.aws.dynamodb.model.TableCreationParameters.ReadOnly
    ] = ZIO.succeed(tableCreationParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ImportTableRequest
  ) extends zio.aws.dynamodb.model.ImportTableRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.dynamodb.model.primitives.ClientToken(value))
    override val s3BucketSource
        : zio.aws.dynamodb.model.S3BucketSource.ReadOnly =
      zio.aws.dynamodb.model.S3BucketSource.wrap(impl.s3BucketSource())
    override val inputFormat: zio.aws.dynamodb.model.InputFormat =
      zio.aws.dynamodb.model.InputFormat.wrap(impl.inputFormat())
    override val inputFormatOptions
        : Optional[zio.aws.dynamodb.model.InputFormatOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputFormatOptions())
        .map(value => zio.aws.dynamodb.model.InputFormatOptions.wrap(value))
    override val inputCompressionType
        : Optional[zio.aws.dynamodb.model.InputCompressionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputCompressionType())
        .map(value => zio.aws.dynamodb.model.InputCompressionType.wrap(value))
    override val tableCreationParameters
        : zio.aws.dynamodb.model.TableCreationParameters.ReadOnly =
      zio.aws.dynamodb.model.TableCreationParameters
        .wrap(impl.tableCreationParameters())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ImportTableRequest
  ): zio.aws.dynamodb.model.ImportTableRequest.ReadOnly = new Wrapper(impl)
}
