package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.AttributeName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchStatementError(
    code: Optional[zio.aws.dynamodb.model.BatchStatementErrorCodeEnum] =
      Optional.Absent,
    message: Optional[String] = Optional.Absent,
    item: Optional[Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.BatchStatementError = {
    import BatchStatementError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.BatchStatementError
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(
        item.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.item)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.BatchStatementError.ReadOnly =
    zio.aws.dynamodb.model.BatchStatementError.wrap(buildAwsValue())
}
object BatchStatementError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.BatchStatementError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.BatchStatementError =
      zio.aws.dynamodb.model.BatchStatementError(
        code.map(value => value),
        message.map(value => value),
        item.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def code: Optional[zio.aws.dynamodb.model.BatchStatementErrorCodeEnum]
    def message: Optional[String]
    def item: Optional[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ]
    def getCode: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.BatchStatementErrorCodeEnum
    ] = AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getItem: ZIO[Any, AwsError, Map[
      AttributeName,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("item", item)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.BatchStatementError
  ) extends zio.aws.dynamodb.model.BatchStatementError.ReadOnly {
    override val code
        : Optional[zio.aws.dynamodb.model.BatchStatementErrorCodeEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.code())
        .map(value =>
          zio.aws.dynamodb.model.BatchStatementErrorCodeEnum.wrap(value)
        )
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
    override val item: Optional[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.item())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.AttributeName(
              key
            ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.BatchStatementError
  ): zio.aws.dynamodb.model.BatchStatementError.ReadOnly = new Wrapper(impl)
}
