package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchExecuteStatementResponse(
    responses: Optional[
      Iterable[zio.aws.dynamodb.model.BatchStatementResponse]
    ] = Optional.Absent,
    consumedCapacity: Optional[
      Iterable[zio.aws.dynamodb.model.ConsumedCapacity]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementResponse = {
    import BatchExecuteStatementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementResponse
      .builder()
      .optionallyWith(
        responses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.responses)
      .optionallyWith(
        consumedCapacity.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.consumedCapacity)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.BatchExecuteStatementResponse.ReadOnly =
    zio.aws.dynamodb.model.BatchExecuteStatementResponse.wrap(buildAwsValue())
}
object BatchExecuteStatementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.BatchExecuteStatementResponse =
      zio.aws.dynamodb.model.BatchExecuteStatementResponse(
        responses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        consumedCapacity.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def responses
        : Optional[List[zio.aws.dynamodb.model.BatchStatementResponse.ReadOnly]]
    def consumedCapacity
        : Optional[List[zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly]]
    def getResponses: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.BatchStatementResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("responses", responses)
    def getConsumedCapacity: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly
    ]] = AwsError.unwrapOptionField("consumedCapacity", consumedCapacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementResponse
  ) extends zio.aws.dynamodb.model.BatchExecuteStatementResponse.ReadOnly {
    override val responses: Optional[
      List[zio.aws.dynamodb.model.BatchStatementResponse.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.responses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.BatchStatementResponse.wrap(item)
        }.toList
      )
    override val consumedCapacity
        : Optional[List[zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.consumedCapacity())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.ConsumedCapacity.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementResponse
  ): zio.aws.dynamodb.model.BatchExecuteStatementResponse.ReadOnly =
    new Wrapper(impl)
}
