package zio.aws.dynamodb.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.dynamodb.model.primitives.{ExportToTime, ExportFromTime}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class IncrementalExportSpecification(
    exportFromTime: Optional[ExportFromTime] = Optional.Absent,
    exportToTime: Optional[ExportToTime] = Optional.Absent,
    exportViewType: Optional[zio.aws.dynamodb.model.ExportViewType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.IncrementalExportSpecification = {
    import IncrementalExportSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.IncrementalExportSpecification
      .builder()
      .optionallyWith(
        exportFromTime.map(value => ExportFromTime.unwrap(value): Instant)
      )(_.exportFromTime)
      .optionallyWith(
        exportToTime.map(value => ExportToTime.unwrap(value): Instant)
      )(_.exportToTime)
      .optionallyWith(exportViewType.map(value => value.unwrap))(
        _.exportViewType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.IncrementalExportSpecification.ReadOnly =
    zio.aws.dynamodb.model.IncrementalExportSpecification.wrap(buildAwsValue())
}
object IncrementalExportSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.IncrementalExportSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.IncrementalExportSpecification =
      zio.aws.dynamodb.model.IncrementalExportSpecification(
        exportFromTime.map(value => value),
        exportToTime.map(value => value),
        exportViewType.map(value => value)
      )
    def exportFromTime: Optional[ExportFromTime]
    def exportToTime: Optional[ExportToTime]
    def exportViewType: Optional[zio.aws.dynamodb.model.ExportViewType]
    def getExportFromTime: ZIO[Any, AwsError, ExportFromTime] =
      AwsError.unwrapOptionField("exportFromTime", exportFromTime)
    def getExportToTime: ZIO[Any, AwsError, ExportToTime] =
      AwsError.unwrapOptionField("exportToTime", exportToTime)
    def getExportViewType
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ExportViewType] =
      AwsError.unwrapOptionField("exportViewType", exportViewType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.IncrementalExportSpecification
  ) extends zio.aws.dynamodb.model.IncrementalExportSpecification.ReadOnly {
    override val exportFromTime: Optional[ExportFromTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exportFromTime())
        .map(value => zio.aws.dynamodb.model.primitives.ExportFromTime(value))
    override val exportToTime: Optional[ExportToTime] = zio.aws.core.internal
      .optionalFromNullable(impl.exportToTime())
      .map(value => zio.aws.dynamodb.model.primitives.ExportToTime(value))
    override val exportViewType
        : Optional[zio.aws.dynamodb.model.ExportViewType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exportViewType())
        .map(value => zio.aws.dynamodb.model.ExportViewType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.IncrementalExportSpecification
  ): zio.aws.dynamodb.model.IncrementalExportSpecification.ReadOnly =
    new Wrapper(impl)
}
