package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters._
sealed trait ExportViewType {
  def unwrap: software.amazon.awssdk.services.dynamodb.model.ExportViewType
}
object ExportViewType {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.ExportViewType
  ): zio.aws.dynamodb.model.ExportViewType = value match {
    case software.amazon.awssdk.services.dynamodb.model.ExportViewType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.ExportViewType.NEW_IMAGE =>
      val r = NEW_IMAGE
      r
    case software.amazon.awssdk.services.dynamodb.model.ExportViewType.NEW_AND_OLD_IMAGES =>
      val r = NEW_AND_OLD_IMAGES
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dynamodb.model.ExportViewType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ExportViewType =
      software.amazon.awssdk.services.dynamodb.model.ExportViewType.UNKNOWN_TO_SDK_VERSION
  }
  case object NEW_IMAGE extends zio.aws.dynamodb.model.ExportViewType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ExportViewType =
      software.amazon.awssdk.services.dynamodb.model.ExportViewType.NEW_IMAGE
  }
  case object NEW_AND_OLD_IMAGES extends zio.aws.dynamodb.model.ExportViewType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ExportViewType =
      software.amazon.awssdk.services.dynamodb.model.ExportViewType.NEW_AND_OLD_IMAGES
  }
}
