package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.IndexName
import scala.jdk.CollectionConverters._
final case class UpdateGlobalSecondaryIndexAction(
    indexName: IndexName,
    provisionedThroughput: zio.aws.dynamodb.model.ProvisionedThroughput
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.UpdateGlobalSecondaryIndexAction = {
    import UpdateGlobalSecondaryIndexAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.UpdateGlobalSecondaryIndexAction
      .builder()
      .indexName(IndexName.unwrap(indexName): java.lang.String)
      .provisionedThroughput(provisionedThroughput.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.UpdateGlobalSecondaryIndexAction.ReadOnly =
    zio.aws.dynamodb.model.UpdateGlobalSecondaryIndexAction
      .wrap(buildAwsValue())
}
object UpdateGlobalSecondaryIndexAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.UpdateGlobalSecondaryIndexAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.UpdateGlobalSecondaryIndexAction =
      zio.aws.dynamodb.model.UpdateGlobalSecondaryIndexAction(
        indexName,
        provisionedThroughput.asEditable
      )
    def indexName: IndexName
    def provisionedThroughput
        : zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly
    def getIndexName: ZIO[Any, Nothing, IndexName] = ZIO.succeed(indexName)
    def getProvisionedThroughput: ZIO[
      Any,
      Nothing,
      zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly
    ] = ZIO.succeed(provisionedThroughput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateGlobalSecondaryIndexAction
  ) extends zio.aws.dynamodb.model.UpdateGlobalSecondaryIndexAction.ReadOnly {
    override val indexName: IndexName =
      zio.aws.dynamodb.model.primitives.IndexName(impl.indexName())
    override val provisionedThroughput
        : zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly =
      zio.aws.dynamodb.model.ProvisionedThroughput
        .wrap(impl.provisionedThroughput())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateGlobalSecondaryIndexAction
  ): zio.aws.dynamodb.model.UpdateGlobalSecondaryIndexAction.ReadOnly =
    new Wrapper(impl)
}
