package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters._
sealed trait ExportType {
  def unwrap: software.amazon.awssdk.services.dynamodb.model.ExportType
}
object ExportType {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.ExportType
  ): zio.aws.dynamodb.model.ExportType = value match {
    case software.amazon.awssdk.services.dynamodb.model.ExportType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.ExportType.FULL_EXPORT =>
      val r = FULL_EXPORT
      r
    case software.amazon.awssdk.services.dynamodb.model.ExportType.INCREMENTAL_EXPORT =>
      val r = INCREMENTAL_EXPORT
      r
  }
  case object unknownToSdkVersion extends zio.aws.dynamodb.model.ExportType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ExportType =
      software.amazon.awssdk.services.dynamodb.model.ExportType.UNKNOWN_TO_SDK_VERSION
  }
  case object FULL_EXPORT extends zio.aws.dynamodb.model.ExportType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ExportType =
      software.amazon.awssdk.services.dynamodb.model.ExportType.FULL_EXPORT
  }
  case object INCREMENTAL_EXPORT extends zio.aws.dynamodb.model.ExportType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ExportType =
      software.amazon.awssdk.services.dynamodb.model.ExportType.INCREMENTAL_EXPORT
  }
}
