package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.BackupArn
import scala.jdk.CollectionConverters._
final case class DescribeBackupRequest(backupArn: BackupArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DescribeBackupRequest = {
    import DescribeBackupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DescribeBackupRequest
      .builder()
      .backupArn(BackupArn.unwrap(backupArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.DescribeBackupRequest.ReadOnly =
    zio.aws.dynamodb.model.DescribeBackupRequest.wrap(buildAwsValue())
}
object DescribeBackupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DescribeBackupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DescribeBackupRequest =
      zio.aws.dynamodb.model.DescribeBackupRequest(backupArn)
    def backupArn: BackupArn
    def getBackupArn: ZIO[Any, Nothing, BackupArn] = ZIO.succeed(backupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeBackupRequest
  ) extends zio.aws.dynamodb.model.DescribeBackupRequest.ReadOnly {
    override val backupArn: BackupArn =
      zio.aws.dynamodb.model.primitives.BackupArn(impl.backupArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeBackupRequest
  ): zio.aws.dynamodb.model.DescribeBackupRequest.ReadOnly = new Wrapper(impl)
}
