package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.BooleanObject
import scala.jdk.CollectionConverters._
final case class PointInTimeRecoverySpecification(
    pointInTimeRecoveryEnabled: BooleanObject
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoverySpecification = {
    import PointInTimeRecoverySpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoverySpecification
      .builder()
      .pointInTimeRecoveryEnabled(pointInTimeRecoveryEnabled: java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.PointInTimeRecoverySpecification.ReadOnly =
    zio.aws.dynamodb.model.PointInTimeRecoverySpecification
      .wrap(buildAwsValue())
}
object PointInTimeRecoverySpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoverySpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.PointInTimeRecoverySpecification =
      zio.aws.dynamodb.model
        .PointInTimeRecoverySpecification(pointInTimeRecoveryEnabled)
    def pointInTimeRecoveryEnabled: BooleanObject
    def getPointInTimeRecoveryEnabled: ZIO[Any, Nothing, BooleanObject] =
      ZIO.succeed(pointInTimeRecoveryEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoverySpecification
  ) extends zio.aws.dynamodb.model.PointInTimeRecoverySpecification.ReadOnly {
    override val pointInTimeRecoveryEnabled: BooleanObject =
      impl.pointInTimeRecoveryEnabled(): BooleanObject
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoverySpecification
  ): zio.aws.dynamodb.model.PointInTimeRecoverySpecification.ReadOnly =
    new Wrapper(impl)
}
