package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{
  ExpressionAttributeNameVariable,
  ProjectionExpression,
  ConsistentRead,
  AttributeName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class KeysAndAttributes(
    keys: Iterable[Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]],
    attributesToGet: Optional[Iterable[AttributeName]] = Optional.Absent,
    consistentRead: Optional[ConsistentRead] = Optional.Absent,
    projectionExpression: Optional[ProjectionExpression] = Optional.Absent,
    expressionAttributeNames: Optional[
      Map[ExpressionAttributeNameVariable, AttributeName]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes = {
    import KeysAndAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes
      .builder()
      .keys(keys.map { item =>
        item
          .map({ case (key, value) =>
            (AttributeName.unwrap(key): java.lang.String) -> value
              .buildAwsValue()
          })
          .asJava
      }.asJavaCollection)
      .optionallyWith(
        attributesToGet.map(value =>
          value.map { item =>
            AttributeName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.attributesToGet)
      .optionallyWith(
        consistentRead.map(value =>
          ConsistentRead.unwrap(value): java.lang.Boolean
        )
      )(_.consistentRead)
      .optionallyWith(
        projectionExpression.map(value =>
          ProjectionExpression.unwrap(value): java.lang.String
        )
      )(_.projectionExpression)
      .optionallyWith(
        expressionAttributeNames.map(value =>
          value
            .map({ case (key, value) =>
              (ExpressionAttributeNameVariable
                .unwrap(key): java.lang.String) -> (AttributeName
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.expressionAttributeNames)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.KeysAndAttributes.ReadOnly =
    zio.aws.dynamodb.model.KeysAndAttributes.wrap(buildAwsValue())
}
object KeysAndAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.KeysAndAttributes =
      zio.aws.dynamodb.model.KeysAndAttributes(
        keys.map { item =>
          item.map({ case (key, value) =>
            key -> value.asEditable
          })
        },
        attributesToGet.map(value => value),
        consistentRead.map(value => value),
        projectionExpression.map(value => value),
        expressionAttributeNames.map(value => value)
      )
    def keys: List[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ]
    def attributesToGet: Optional[List[AttributeName]]
    def consistentRead: Optional[ConsistentRead]
    def projectionExpression: Optional[ProjectionExpression]
    def expressionAttributeNames
        : Optional[Map[ExpressionAttributeNameVariable, AttributeName]]
    def getKeys: ZIO[Any, Nothing, List[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ]] = ZIO.succeed(keys)
    def getAttributesToGet: ZIO[Any, AwsError, List[AttributeName]] =
      AwsError.unwrapOptionField("attributesToGet", attributesToGet)
    def getConsistentRead: ZIO[Any, AwsError, ConsistentRead] =
      AwsError.unwrapOptionField("consistentRead", consistentRead)
    def getProjectionExpression: ZIO[Any, AwsError, ProjectionExpression] =
      AwsError.unwrapOptionField("projectionExpression", projectionExpression)
    def getExpressionAttributeNames: ZIO[Any, AwsError, Map[
      ExpressionAttributeNameVariable,
      AttributeName
    ]] = AwsError.unwrapOptionField(
      "expressionAttributeNames",
      expressionAttributeNames
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes
  ) extends zio.aws.dynamodb.model.KeysAndAttributes.ReadOnly {
    override val keys: List[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ] = impl
      .keys()
      .asScala
      .map { item =>
        item.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.AttributeName(
              key
            ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
          })
          .toMap
      }
      .toList
    override val attributesToGet: Optional[List[AttributeName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributesToGet())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.primitives.AttributeName(item)
          }.toList
        )
    override val consistentRead: Optional[ConsistentRead] =
      zio.aws.core.internal
        .optionalFromNullable(impl.consistentRead())
        .map(value => zio.aws.dynamodb.model.primitives.ConsistentRead(value))
    override val projectionExpression: Optional[ProjectionExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.projectionExpression())
        .map(value =>
          zio.aws.dynamodb.model.primitives.ProjectionExpression(value)
        )
    override val expressionAttributeNames
        : Optional[Map[ExpressionAttributeNameVariable, AttributeName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expressionAttributeNames())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.dynamodb.model.primitives.ExpressionAttributeNameVariable(
                key
              ) -> zio.aws.dynamodb.model.primitives.AttributeName(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes
  ): zio.aws.dynamodb.model.KeysAndAttributes.ReadOnly = new Wrapper(impl)
}
