package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters._
sealed trait ImportStatus {
  def unwrap: software.amazon.awssdk.services.dynamodb.model.ImportStatus
}
object ImportStatus {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.ImportStatus
  ): zio.aws.dynamodb.model.ImportStatus = value match {
    case software.amazon.awssdk.services.dynamodb.model.ImportStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.ImportStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.dynamodb.model.ImportStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.dynamodb.model.ImportStatus.CANCELLING =>
      val r = CANCELLING
      r
    case software.amazon.awssdk.services.dynamodb.model.ImportStatus.CANCELLED =>
      val r = CANCELLED
      r
    case software.amazon.awssdk.services.dynamodb.model.ImportStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.dynamodb.model.ImportStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ImportStatus =
      software.amazon.awssdk.services.dynamodb.model.ImportStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS extends zio.aws.dynamodb.model.ImportStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ImportStatus =
      software.amazon.awssdk.services.dynamodb.model.ImportStatus.IN_PROGRESS
  }
  case object COMPLETED extends zio.aws.dynamodb.model.ImportStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ImportStatus =
      software.amazon.awssdk.services.dynamodb.model.ImportStatus.COMPLETED
  }
  case object CANCELLING extends zio.aws.dynamodb.model.ImportStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ImportStatus =
      software.amazon.awssdk.services.dynamodb.model.ImportStatus.CANCELLING
  }
  case object CANCELLED extends zio.aws.dynamodb.model.ImportStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ImportStatus =
      software.amazon.awssdk.services.dynamodb.model.ImportStatus.CANCELLED
  }
  case object FAILED extends zio.aws.dynamodb.model.ImportStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ImportStatus =
      software.amazon.awssdk.services.dynamodb.model.ImportStatus.FAILED
  }
}
