package zio.aws.dynamodb.model
import zio.prelude.data.Optional
import zio.aws.dynamodb.model.primitives.{ListTablesInputLimit, TableName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTablesRequest(
    exclusiveStartTableName: Optional[TableName] = Optional.Absent,
    limit: Optional[ListTablesInputLimit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ListTablesRequest = {
    import ListTablesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ListTablesRequest
      .builder()
      .optionallyWith(
        exclusiveStartTableName.map(value =>
          TableName.unwrap(value): java.lang.String
        )
      )(_.exclusiveStartTableName)
      .optionallyWith(
        limit.map(value => ListTablesInputLimit.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ListTablesRequest.ReadOnly =
    zio.aws.dynamodb.model.ListTablesRequest.wrap(buildAwsValue())
}
object ListTablesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ListTablesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ListTablesRequest =
      zio.aws.dynamodb.model.ListTablesRequest(
        exclusiveStartTableName.map(value => value),
        limit.map(value => value)
      )
    def exclusiveStartTableName: Optional[TableName]
    def limit: Optional[ListTablesInputLimit]
    def getExclusiveStartTableName: ZIO[Any, AwsError, TableName] = AwsError
      .unwrapOptionField("exclusiveStartTableName", exclusiveStartTableName)
    def getLimit: ZIO[Any, AwsError, ListTablesInputLimit] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ListTablesRequest
  ) extends zio.aws.dynamodb.model.ListTablesRequest.ReadOnly {
    override val exclusiveStartTableName: Optional[TableName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exclusiveStartTableName())
        .map(value => zio.aws.dynamodb.model.primitives.TableName(value))
    override val limit: Optional[ListTablesInputLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value =>
        zio.aws.dynamodb.model.primitives.ListTablesInputLimit(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ListTablesRequest
  ): zio.aws.dynamodb.model.ListTablesRequest.ReadOnly = new Wrapper(impl)
}
