package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{LongObject, Backfilling, IndexName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GlobalSecondaryIndexDescription(
    indexName: Optional[IndexName] = Optional.Absent,
    keySchema: Optional[Iterable[zio.aws.dynamodb.model.KeySchemaElement]] =
      Optional.Absent,
    projection: Optional[zio.aws.dynamodb.model.Projection] = Optional.Absent,
    indexStatus: Optional[zio.aws.dynamodb.model.IndexStatus] = Optional.Absent,
    backfilling: Optional[Backfilling] = Optional.Absent,
    provisionedThroughput: Optional[
      zio.aws.dynamodb.model.ProvisionedThroughputDescription
    ] = Optional.Absent,
    indexSizeBytes: Optional[LongObject] = Optional.Absent,
    itemCount: Optional[LongObject] = Optional.Absent,
    indexArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexDescription = {
    import GlobalSecondaryIndexDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexDescription
      .builder()
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(
        keySchema.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keySchema)
      .optionallyWith(projection.map(value => value.buildAwsValue()))(
        _.projection
      )
      .optionallyWith(indexStatus.map(value => value.unwrap))(_.indexStatus)
      .optionallyWith(
        backfilling.map(value => Backfilling.unwrap(value): java.lang.Boolean)
      )(_.backfilling)
      .optionallyWith(
        provisionedThroughput.map(value => value.buildAwsValue())
      )(_.provisionedThroughput)
      .optionallyWith(indexSizeBytes.map(value => value: java.lang.Long))(
        _.indexSizeBytes
      )
      .optionallyWith(itemCount.map(value => value: java.lang.Long))(
        _.itemCount
      )
      .optionallyWith(indexArn.map(value => value: java.lang.String))(
        _.indexArn
      )
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.GlobalSecondaryIndexDescription.ReadOnly =
    zio.aws.dynamodb.model.GlobalSecondaryIndexDescription.wrap(buildAwsValue())
}
object GlobalSecondaryIndexDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.GlobalSecondaryIndexDescription =
      zio.aws.dynamodb.model.GlobalSecondaryIndexDescription(
        indexName.map(value => value),
        keySchema.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        projection.map(value => value.asEditable),
        indexStatus.map(value => value),
        backfilling.map(value => value),
        provisionedThroughput.map(value => value.asEditable),
        indexSizeBytes.map(value => value),
        itemCount.map(value => value),
        indexArn.map(value => value)
      )
    def indexName: Optional[IndexName]
    def keySchema
        : Optional[List[zio.aws.dynamodb.model.KeySchemaElement.ReadOnly]]
    def projection: Optional[zio.aws.dynamodb.model.Projection.ReadOnly]
    def indexStatus: Optional[zio.aws.dynamodb.model.IndexStatus]
    def backfilling: Optional[Backfilling]
    def provisionedThroughput: Optional[
      zio.aws.dynamodb.model.ProvisionedThroughputDescription.ReadOnly
    ]
    def indexSizeBytes: Optional[LongObject]
    def itemCount: Optional[LongObject]
    def indexArn: Optional[String]
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getKeySchema: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.KeySchemaElement.ReadOnly
    ]] = AwsError.unwrapOptionField("keySchema", keySchema)
    def getProjection
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.Projection.ReadOnly] =
      AwsError.unwrapOptionField("projection", projection)
    def getIndexStatus: ZIO[Any, AwsError, zio.aws.dynamodb.model.IndexStatus] =
      AwsError.unwrapOptionField("indexStatus", indexStatus)
    def getBackfilling: ZIO[Any, AwsError, Backfilling] =
      AwsError.unwrapOptionField("backfilling", backfilling)
    def getProvisionedThroughput: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ProvisionedThroughputDescription.ReadOnly
    ] =
      AwsError.unwrapOptionField("provisionedThroughput", provisionedThroughput)
    def getIndexSizeBytes: ZIO[Any, AwsError, LongObject] =
      AwsError.unwrapOptionField("indexSizeBytes", indexSizeBytes)
    def getItemCount: ZIO[Any, AwsError, LongObject] =
      AwsError.unwrapOptionField("itemCount", itemCount)
    def getIndexArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("indexArn", indexArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexDescription
  ) extends zio.aws.dynamodb.model.GlobalSecondaryIndexDescription.ReadOnly {
    override val indexName: Optional[IndexName] = zio.aws.core.internal
      .optionalFromNullable(impl.indexName())
      .map(value => zio.aws.dynamodb.model.primitives.IndexName(value))
    override val keySchema
        : Optional[List[zio.aws.dynamodb.model.KeySchemaElement.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keySchema())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.KeySchemaElement.wrap(item)
          }.toList
        )
    override val projection
        : Optional[zio.aws.dynamodb.model.Projection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.projection())
        .map(value => zio.aws.dynamodb.model.Projection.wrap(value))
    override val indexStatus: Optional[zio.aws.dynamodb.model.IndexStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.indexStatus())
        .map(value => zio.aws.dynamodb.model.IndexStatus.wrap(value))
    override val backfilling: Optional[Backfilling] = zio.aws.core.internal
      .optionalFromNullable(impl.backfilling())
      .map(value => zio.aws.dynamodb.model.primitives.Backfilling(value))
    override val provisionedThroughput: Optional[
      zio.aws.dynamodb.model.ProvisionedThroughputDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionedThroughput())
      .map(value =>
        zio.aws.dynamodb.model.ProvisionedThroughputDescription.wrap(value)
      )
    override val indexSizeBytes: Optional[LongObject] = zio.aws.core.internal
      .optionalFromNullable(impl.indexSizeBytes())
      .map(value => value: LongObject)
    override val itemCount: Optional[LongObject] = zio.aws.core.internal
      .optionalFromNullable(impl.itemCount())
      .map(value => value: LongObject)
    override val indexArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.indexArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexDescription
  ): zio.aws.dynamodb.model.GlobalSecondaryIndexDescription.ReadOnly =
    new Wrapper(impl)
}
