package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.PositiveLongObject
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeLimitsResponse(
    accountMaxReadCapacityUnits: Optional[PositiveLongObject] = Optional.Absent,
    accountMaxWriteCapacityUnits: Optional[PositiveLongObject] =
      Optional.Absent,
    tableMaxReadCapacityUnits: Optional[PositiveLongObject] = Optional.Absent,
    tableMaxWriteCapacityUnits: Optional[PositiveLongObject] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DescribeLimitsResponse = {
    import DescribeLimitsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DescribeLimitsResponse
      .builder()
      .optionallyWith(
        accountMaxReadCapacityUnits.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.accountMaxReadCapacityUnits)
      .optionallyWith(
        accountMaxWriteCapacityUnits.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.accountMaxWriteCapacityUnits)
      .optionallyWith(
        tableMaxReadCapacityUnits.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.tableMaxReadCapacityUnits)
      .optionallyWith(
        tableMaxWriteCapacityUnits.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.tableMaxWriteCapacityUnits)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.DescribeLimitsResponse.ReadOnly =
    zio.aws.dynamodb.model.DescribeLimitsResponse.wrap(buildAwsValue())
}
object DescribeLimitsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DescribeLimitsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DescribeLimitsResponse =
      zio.aws.dynamodb.model.DescribeLimitsResponse(
        accountMaxReadCapacityUnits.map(value => value),
        accountMaxWriteCapacityUnits.map(value => value),
        tableMaxReadCapacityUnits.map(value => value),
        tableMaxWriteCapacityUnits.map(value => value)
      )
    def accountMaxReadCapacityUnits: Optional[PositiveLongObject]
    def accountMaxWriteCapacityUnits: Optional[PositiveLongObject]
    def tableMaxReadCapacityUnits: Optional[PositiveLongObject]
    def tableMaxWriteCapacityUnits: Optional[PositiveLongObject]
    def getAccountMaxReadCapacityUnits: ZIO[Any, AwsError, PositiveLongObject] =
      AwsError.unwrapOptionField(
        "accountMaxReadCapacityUnits",
        accountMaxReadCapacityUnits
      )
    def getAccountMaxWriteCapacityUnits
        : ZIO[Any, AwsError, PositiveLongObject] = AwsError.unwrapOptionField(
      "accountMaxWriteCapacityUnits",
      accountMaxWriteCapacityUnits
    )
    def getTableMaxReadCapacityUnits: ZIO[Any, AwsError, PositiveLongObject] =
      AwsError.unwrapOptionField(
        "tableMaxReadCapacityUnits",
        tableMaxReadCapacityUnits
      )
    def getTableMaxWriteCapacityUnits: ZIO[Any, AwsError, PositiveLongObject] =
      AwsError.unwrapOptionField(
        "tableMaxWriteCapacityUnits",
        tableMaxWriteCapacityUnits
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeLimitsResponse
  ) extends zio.aws.dynamodb.model.DescribeLimitsResponse.ReadOnly {
    override val accountMaxReadCapacityUnits: Optional[PositiveLongObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountMaxReadCapacityUnits())
        .map(value =>
          zio.aws.dynamodb.model.primitives.PositiveLongObject(value)
        )
    override val accountMaxWriteCapacityUnits: Optional[PositiveLongObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountMaxWriteCapacityUnits())
        .map(value =>
          zio.aws.dynamodb.model.primitives.PositiveLongObject(value)
        )
    override val tableMaxReadCapacityUnits: Optional[PositiveLongObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tableMaxReadCapacityUnits())
        .map(value =>
          zio.aws.dynamodb.model.primitives.PositiveLongObject(value)
        )
    override val tableMaxWriteCapacityUnits: Optional[PositiveLongObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tableMaxWriteCapacityUnits())
        .map(value =>
          zio.aws.dynamodb.model.primitives.PositiveLongObject(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeLimitsResponse
  ): zio.aws.dynamodb.model.DescribeLimitsResponse.ReadOnly = new Wrapper(impl)
}
