package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{DeletionProtectionEnabled, TableName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateTableRequest(
    attributeDefinitions: Optional[
      Iterable[zio.aws.dynamodb.model.AttributeDefinition]
    ] = Optional.Absent,
    tableName: TableName,
    billingMode: Optional[zio.aws.dynamodb.model.BillingMode] = Optional.Absent,
    provisionedThroughput: Optional[
      zio.aws.dynamodb.model.ProvisionedThroughput
    ] = Optional.Absent,
    globalSecondaryIndexUpdates: Optional[
      Iterable[zio.aws.dynamodb.model.GlobalSecondaryIndexUpdate]
    ] = Optional.Absent,
    streamSpecification: Optional[zio.aws.dynamodb.model.StreamSpecification] =
      Optional.Absent,
    sseSpecification: Optional[zio.aws.dynamodb.model.SSESpecification] =
      Optional.Absent,
    replicaUpdates: Optional[
      Iterable[zio.aws.dynamodb.model.ReplicationGroupUpdate]
    ] = Optional.Absent,
    tableClass: Optional[zio.aws.dynamodb.model.TableClass] = Optional.Absent,
    deletionProtectionEnabled: Optional[DeletionProtectionEnabled] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest = {
    import UpdateTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest
      .builder()
      .optionallyWith(
        attributeDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributeDefinitions)
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .optionallyWith(billingMode.map(value => value.unwrap))(_.billingMode)
      .optionallyWith(
        provisionedThroughput.map(value => value.buildAwsValue())
      )(_.provisionedThroughput)
      .optionallyWith(
        globalSecondaryIndexUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalSecondaryIndexUpdates)
      .optionallyWith(streamSpecification.map(value => value.buildAwsValue()))(
        _.streamSpecification
      )
      .optionallyWith(sseSpecification.map(value => value.buildAwsValue()))(
        _.sseSpecification
      )
      .optionallyWith(
        replicaUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicaUpdates)
      .optionallyWith(tableClass.map(value => value.unwrap))(_.tableClass)
      .optionallyWith(
        deletionProtectionEnabled.map(value =>
          DeletionProtectionEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.deletionProtectionEnabled)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.UpdateTableRequest.ReadOnly =
    zio.aws.dynamodb.model.UpdateTableRequest.wrap(buildAwsValue())
}
object UpdateTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.UpdateTableRequest =
      zio.aws.dynamodb.model.UpdateTableRequest(
        attributeDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tableName,
        billingMode.map(value => value),
        provisionedThroughput.map(value => value.asEditable),
        globalSecondaryIndexUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        streamSpecification.map(value => value.asEditable),
        sseSpecification.map(value => value.asEditable),
        replicaUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tableClass.map(value => value),
        deletionProtectionEnabled.map(value => value)
      )
    def attributeDefinitions
        : Optional[List[zio.aws.dynamodb.model.AttributeDefinition.ReadOnly]]
    def tableName: TableName
    def billingMode: Optional[zio.aws.dynamodb.model.BillingMode]
    def provisionedThroughput
        : Optional[zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly]
    def globalSecondaryIndexUpdates: Optional[
      List[zio.aws.dynamodb.model.GlobalSecondaryIndexUpdate.ReadOnly]
    ]
    def streamSpecification
        : Optional[zio.aws.dynamodb.model.StreamSpecification.ReadOnly]
    def sseSpecification
        : Optional[zio.aws.dynamodb.model.SSESpecification.ReadOnly]
    def replicaUpdates
        : Optional[List[zio.aws.dynamodb.model.ReplicationGroupUpdate.ReadOnly]]
    def tableClass: Optional[zio.aws.dynamodb.model.TableClass]
    def deletionProtectionEnabled: Optional[DeletionProtectionEnabled]
    def getAttributeDefinitions: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.AttributeDefinition.ReadOnly
    ]] =
      AwsError.unwrapOptionField("attributeDefinitions", attributeDefinitions)
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getBillingMode: ZIO[Any, AwsError, zio.aws.dynamodb.model.BillingMode] =
      AwsError.unwrapOptionField("billingMode", billingMode)
    def getProvisionedThroughput: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly
    ] =
      AwsError.unwrapOptionField("provisionedThroughput", provisionedThroughput)
    def getGlobalSecondaryIndexUpdates: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.GlobalSecondaryIndexUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "globalSecondaryIndexUpdates",
      globalSecondaryIndexUpdates
    )
    def getStreamSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.StreamSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("streamSpecification", streamSpecification)
    def getSseSpecification
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.SSESpecification.ReadOnly] =
      AwsError.unwrapOptionField("sseSpecification", sseSpecification)
    def getReplicaUpdates: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ReplicationGroupUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField("replicaUpdates", replicaUpdates)
    def getTableClass: ZIO[Any, AwsError, zio.aws.dynamodb.model.TableClass] =
      AwsError.unwrapOptionField("tableClass", tableClass)
    def getDeletionProtectionEnabled
        : ZIO[Any, AwsError, DeletionProtectionEnabled] = AwsError
      .unwrapOptionField("deletionProtectionEnabled", deletionProtectionEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest
  ) extends zio.aws.dynamodb.model.UpdateTableRequest.ReadOnly {
    override val attributeDefinitions
        : Optional[List[zio.aws.dynamodb.model.AttributeDefinition.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributeDefinitions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.AttributeDefinition.wrap(item)
          }.toList
        )
    override val tableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.tableName())
    override val billingMode: Optional[zio.aws.dynamodb.model.BillingMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.billingMode())
        .map(value => zio.aws.dynamodb.model.BillingMode.wrap(value))
    override val provisionedThroughput
        : Optional[zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionedThroughput())
        .map(value => zio.aws.dynamodb.model.ProvisionedThroughput.wrap(value))
    override val globalSecondaryIndexUpdates: Optional[
      List[zio.aws.dynamodb.model.GlobalSecondaryIndexUpdate.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.globalSecondaryIndexUpdates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.GlobalSecondaryIndexUpdate.wrap(item)
        }.toList
      )
    override val streamSpecification
        : Optional[zio.aws.dynamodb.model.StreamSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamSpecification())
        .map(value => zio.aws.dynamodb.model.StreamSpecification.wrap(value))
    override val sseSpecification
        : Optional[zio.aws.dynamodb.model.SSESpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseSpecification())
        .map(value => zio.aws.dynamodb.model.SSESpecification.wrap(value))
    override val replicaUpdates: Optional[
      List[zio.aws.dynamodb.model.ReplicationGroupUpdate.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.replicaUpdates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.ReplicationGroupUpdate.wrap(item)
        }.toList
      )
    override val tableClass: Optional[zio.aws.dynamodb.model.TableClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tableClass())
        .map(value => zio.aws.dynamodb.model.TableClass.wrap(value))
    override val deletionProtectionEnabled
        : Optional[DeletionProtectionEnabled] = zio.aws.core.internal
      .optionalFromNullable(impl.deletionProtectionEnabled())
      .map(value =>
        zio.aws.dynamodb.model.primitives.DeletionProtectionEnabled(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest
  ): zio.aws.dynamodb.model.UpdateTableRequest.ReadOnly = new Wrapper(impl)
}
