package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.ResourceArnString
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: ResourceArnString,
    tags: Iterable[zio.aws.dynamodb.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.TagResourceRequest
      .builder()
      .resourceArn(ResourceArnString.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.TagResourceRequest.ReadOnly =
    zio.aws.dynamodb.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.TagResourceRequest =
      zio.aws.dynamodb.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: ResourceArnString
    def tags: List[zio.aws.dynamodb.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, ResourceArnString] =
      ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, List[zio.aws.dynamodb.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.TagResourceRequest
  ) extends zio.aws.dynamodb.model.TagResourceRequest.ReadOnly {
    override val resourceArn: ResourceArnString =
      zio.aws.dynamodb.model.primitives.ResourceArnString(impl.resourceArn())
    override val tags: List[zio.aws.dynamodb.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.dynamodb.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.TagResourceRequest
  ): zio.aws.dynamodb.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
